// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type EnableFastSnapshotRestoresInput struct {
	_ struct{} `type:"structure"`

	// One or more Availability Zones. For example, us-east-2a.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []string `locationName:"AvailabilityZone" locationNameList:"AvailabilityZone" type:"list" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of one or more snapshots. For example, snap-1234567890abcdef0. You
	// can specify a snapshot that was shared with you from another AWS account.
	//
	// SourceSnapshotIds is a required field
	SourceSnapshotIds []string `locationName:"SourceSnapshotId" locationNameList:"SnapshotId" type:"list" required:"true"`
}

// String returns the string representation
func (s EnableFastSnapshotRestoresInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableFastSnapshotRestoresInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableFastSnapshotRestoresInput"}

	if s.AvailabilityZones == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZones"))
	}

	if s.SourceSnapshotIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceSnapshotIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableFastSnapshotRestoresOutput struct {
	_ struct{} `type:"structure"`

	// Information about the snapshots for which fast snapshot restores were successfully
	// enabled.
	Successful []EnableFastSnapshotRestoreSuccessItem `locationName:"successful" locationNameList:"item" type:"list"`

	// Information about the snapshots for which fast snapshot restores could not
	// be enabled.
	Unsuccessful []EnableFastSnapshotRestoreErrorItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s EnableFastSnapshotRestoresOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableFastSnapshotRestores = "EnableFastSnapshotRestores"

// EnableFastSnapshotRestoresRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Enables fast snapshot restores for the specified snapshots in the specified
// Availability Zones.
//
// You get the full benefit of fast snapshot restores after they enter the enabled
// state. To get the current state of fast snapshot restores, use DescribeFastSnapshotRestores.
// To disable fast snapshot restores, use DisableFastSnapshotRestores.
//
// For more information, see Amazon EBS Fast Snapshot Restore (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-fast-snapshot-restore.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using EnableFastSnapshotRestoresRequest.
//    req := client.EnableFastSnapshotRestoresRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableFastSnapshotRestores
func (c *Client) EnableFastSnapshotRestoresRequest(input *EnableFastSnapshotRestoresInput) EnableFastSnapshotRestoresRequest {
	op := &aws.Operation{
		Name:       opEnableFastSnapshotRestores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableFastSnapshotRestoresInput{}
	}

	req := c.newRequest(op, input, &EnableFastSnapshotRestoresOutput{})

	return EnableFastSnapshotRestoresRequest{Request: req, Input: input, Copy: c.EnableFastSnapshotRestoresRequest}
}

// EnableFastSnapshotRestoresRequest is the request type for the
// EnableFastSnapshotRestores API operation.
type EnableFastSnapshotRestoresRequest struct {
	*aws.Request
	Input *EnableFastSnapshotRestoresInput
	Copy  func(*EnableFastSnapshotRestoresInput) EnableFastSnapshotRestoresRequest
}

// Send marshals and sends the EnableFastSnapshotRestores API request.
func (r EnableFastSnapshotRestoresRequest) Send(ctx context.Context) (*EnableFastSnapshotRestoresResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableFastSnapshotRestoresResponse{
		EnableFastSnapshotRestoresOutput: r.Request.Data.(*EnableFastSnapshotRestoresOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableFastSnapshotRestoresResponse is the response type for the
// EnableFastSnapshotRestores API operation.
type EnableFastSnapshotRestoresResponse struct {
	*EnableFastSnapshotRestoresOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableFastSnapshotRestores request.
func (r *EnableFastSnapshotRestoresResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
