// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type DisassociateRouteTableInput struct {
	_ struct{} `type:"structure"`

	// The association ID representing the current association between the route
	// table and subnet or gateway.
	//
	// AssociationId is a required field
	AssociationId *string `locationName:"associationId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s DisassociateRouteTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateRouteTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateRouteTableInput"}

	if s.AssociationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssociationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateRouteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateRouteTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateRouteTable = "DisassociateRouteTable"

// DisassociateRouteTableRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disassociates a subnet or gateway from a route table.
//
// After you perform this action, the subnet no longer uses the routes in the
// route table. Instead, it uses the routes in the VPC's main route table. For
// more information about route tables, see Route Tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
//    // Example sending a request using DisassociateRouteTableRequest.
//    req := client.DisassociateRouteTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateRouteTable
func (c *Client) DisassociateRouteTableRequest(input *DisassociateRouteTableInput) DisassociateRouteTableRequest {
	op := &aws.Operation{
		Name:       opDisassociateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateRouteTableInput{}
	}

	req := c.newRequest(op, input, &DisassociateRouteTableOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisassociateRouteTableRequest{Request: req, Input: input, Copy: c.DisassociateRouteTableRequest}
}

// DisassociateRouteTableRequest is the request type for the
// DisassociateRouteTable API operation.
type DisassociateRouteTableRequest struct {
	*aws.Request
	Input *DisassociateRouteTableInput
	Copy  func(*DisassociateRouteTableInput) DisassociateRouteTableRequest
}

// Send marshals and sends the DisassociateRouteTable API request.
func (r DisassociateRouteTableRequest) Send(ctx context.Context) (*DisassociateRouteTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateRouteTableResponse{
		DisassociateRouteTableOutput: r.Request.Data.(*DisassociateRouteTableOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateRouteTableResponse is the response type for the
// DisassociateRouteTable API operation.
type DisassociateRouteTableResponse struct {
	*DisassociateRouteTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateRouteTable request.
func (r *DisassociateRouteTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
