// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeScheduledInstances.
type DescribeScheduledInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The filters.
	//
	//    * availability-zone - The Availability Zone (for example, us-west-2a).
	//
	//    * instance-type - The instance type (for example, c4.large).
	//
	//    * network-platform - The network platform (EC2-Classic or EC2-VPC).
	//
	//    * platform - The platform (Linux/UNIX or Windows).
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return in a single call. This value can
	// be between 5 and 300. The default value is 100. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The Scheduled Instance IDs.
	ScheduledInstanceIds []string `locationName:"ScheduledInstanceId" locationNameList:"ScheduledInstanceId" type:"list"`

	// The time period for the first schedule to start.
	SlotStartTimeRange *SlotStartTimeRangeRequest `type:"structure"`
}

// String returns the string representation
func (s DescribeScheduledInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of DescribeScheduledInstances.
type DescribeScheduledInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the Scheduled Instances.
	ScheduledInstanceSet []ScheduledInstance `locationName:"scheduledInstanceSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeScheduledInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeScheduledInstances = "DescribeScheduledInstances"

// DescribeScheduledInstancesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the specified Scheduled Instances or all your Scheduled Instances.
//
//    // Example sending a request using DescribeScheduledInstancesRequest.
//    req := client.DescribeScheduledInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances
func (c *Client) DescribeScheduledInstancesRequest(input *DescribeScheduledInstancesInput) DescribeScheduledInstancesRequest {
	op := &aws.Operation{
		Name:       opDescribeScheduledInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledInstancesInput{}
	}

	req := c.newRequest(op, input, &DescribeScheduledInstancesOutput{})

	return DescribeScheduledInstancesRequest{Request: req, Input: input, Copy: c.DescribeScheduledInstancesRequest}
}

// DescribeScheduledInstancesRequest is the request type for the
// DescribeScheduledInstances API operation.
type DescribeScheduledInstancesRequest struct {
	*aws.Request
	Input *DescribeScheduledInstancesInput
	Copy  func(*DescribeScheduledInstancesInput) DescribeScheduledInstancesRequest
}

// Send marshals and sends the DescribeScheduledInstances API request.
func (r DescribeScheduledInstancesRequest) Send(ctx context.Context) (*DescribeScheduledInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeScheduledInstancesResponse{
		DescribeScheduledInstancesOutput: r.Request.Data.(*DescribeScheduledInstancesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeScheduledInstancesRequestPaginator returns a paginator for DescribeScheduledInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeScheduledInstancesRequest(input)
//   p := ec2.NewDescribeScheduledInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeScheduledInstancesPaginator(req DescribeScheduledInstancesRequest) DescribeScheduledInstancesPaginator {
	return DescribeScheduledInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeScheduledInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeScheduledInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeScheduledInstancesPaginator struct {
	aws.Pager
}

func (p *DescribeScheduledInstancesPaginator) CurrentPage() *DescribeScheduledInstancesOutput {
	return p.Pager.CurrentPage().(*DescribeScheduledInstancesOutput)
}

// DescribeScheduledInstancesResponse is the response type for the
// DescribeScheduledInstances API operation.
type DescribeScheduledInstancesResponse struct {
	*DescribeScheduledInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeScheduledInstances request.
func (r *DescribeScheduledInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
