// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteEgressOnlyInternetGatewayInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the egress-only internet gateway.
	//
	// EgressOnlyInternetGatewayId is a required field
	EgressOnlyInternetGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEgressOnlyInternetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEgressOnlyInternetGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEgressOnlyInternetGatewayInput"}

	if s.EgressOnlyInternetGatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EgressOnlyInternetGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEgressOnlyInternetGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	ReturnCode *bool `locationName:"returnCode" type:"boolean"`
}

// String returns the string representation
func (s DeleteEgressOnlyInternetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEgressOnlyInternetGateway = "DeleteEgressOnlyInternetGateway"

// DeleteEgressOnlyInternetGatewayRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes an egress-only internet gateway.
//
//    // Example sending a request using DeleteEgressOnlyInternetGatewayRequest.
//    req := client.DeleteEgressOnlyInternetGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway
func (c *Client) DeleteEgressOnlyInternetGatewayRequest(input *DeleteEgressOnlyInternetGatewayInput) DeleteEgressOnlyInternetGatewayRequest {
	op := &aws.Operation{
		Name:       opDeleteEgressOnlyInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEgressOnlyInternetGatewayInput{}
	}

	req := c.newRequest(op, input, &DeleteEgressOnlyInternetGatewayOutput{})

	return DeleteEgressOnlyInternetGatewayRequest{Request: req, Input: input, Copy: c.DeleteEgressOnlyInternetGatewayRequest}
}

// DeleteEgressOnlyInternetGatewayRequest is the request type for the
// DeleteEgressOnlyInternetGateway API operation.
type DeleteEgressOnlyInternetGatewayRequest struct {
	*aws.Request
	Input *DeleteEgressOnlyInternetGatewayInput
	Copy  func(*DeleteEgressOnlyInternetGatewayInput) DeleteEgressOnlyInternetGatewayRequest
}

// Send marshals and sends the DeleteEgressOnlyInternetGateway API request.
func (r DeleteEgressOnlyInternetGatewayRequest) Send(ctx context.Context) (*DeleteEgressOnlyInternetGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEgressOnlyInternetGatewayResponse{
		DeleteEgressOnlyInternetGatewayOutput: r.Request.Data.(*DeleteEgressOnlyInternetGatewayOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEgressOnlyInternetGatewayResponse is the response type for the
// DeleteEgressOnlyInternetGateway API operation.
type DeleteEgressOnlyInternetGatewayResponse struct {
	*DeleteEgressOnlyInternetGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEgressOnlyInternetGateway request.
func (r *DeleteEgressOnlyInternetGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
