// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A unique name for the key pair.
	//
	// Constraints: Up to 255 ASCII characters
	//
	// KeyName is a required field
	KeyName *string `type:"string" required:"true"`

	// The tags to apply to the new key pair.
	TagSpecifications []TagSpecification `locationName:"TagSpecification" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyPairInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateKeyPairInput"}

	if s.KeyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a key pair.
type CreateKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// The SHA-1 digest of the DER encoded private key.
	KeyFingerprint *string `locationName:"keyFingerprint" type:"string"`

	// An unencrypted PEM encoded RSA private key.
	KeyMaterial *string `locationName:"keyMaterial" type:"string" sensitive:"true"`

	// The name of the key pair.
	KeyName *string `locationName:"keyName" type:"string"`

	// The ID of the key pair.
	KeyPairId *string `locationName:"keyPairId" type:"string"`

	// Any tags applied to the key pair.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CreateKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores
// the public key and displays the private key for you to save to a file. The
// private key is returned as an unencrypted PEM encoded PKCS#1 private key.
// If a key with the specified name already exists, Amazon EC2 returns an error.
//
// You can have up to five thousand key pairs per Region.
//
// The key pair returned to you is available only in the Region in which you
// create it. If you prefer, you can create your own key pair using a third-party
// tool and upload it to any Region using ImportKeyPair.
//
// For more information, see Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using CreateKeyPairRequest.
//    req := client.CreateKeyPairRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair
func (c *Client) CreateKeyPairRequest(input *CreateKeyPairInput) CreateKeyPairRequest {
	op := &aws.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	req := c.newRequest(op, input, &CreateKeyPairOutput{})

	return CreateKeyPairRequest{Request: req, Input: input, Copy: c.CreateKeyPairRequest}
}

// CreateKeyPairRequest is the request type for the
// CreateKeyPair API operation.
type CreateKeyPairRequest struct {
	*aws.Request
	Input *CreateKeyPairInput
	Copy  func(*CreateKeyPairInput) CreateKeyPairRequest
}

// Send marshals and sends the CreateKeyPair API request.
func (r CreateKeyPairRequest) Send(ctx context.Context) (*CreateKeyPairResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateKeyPairResponse{
		CreateKeyPairOutput: r.Request.Data.(*CreateKeyPairOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateKeyPairResponse is the response type for the
// CreateKeyPair API operation.
type CreateKeyPairResponse struct {
	*CreateKeyPairOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateKeyPair request.
func (r *CreateKeyPairResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
