// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateIamInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The IAM instance profile.
	//
	// IamInstanceProfile is a required field
	IamInstanceProfile *IamInstanceProfileSpecification `type:"structure" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateIamInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIamInstanceProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateIamInstanceProfileInput"}

	if s.IamInstanceProfile == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamInstanceProfile"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateIamInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IAM instance profile association.
	IamInstanceProfileAssociation *IamInstanceProfileAssociation `locationName:"iamInstanceProfileAssociation" type:"structure"`
}

// String returns the string representation
func (s AssociateIamInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateIamInstanceProfile = "AssociateIamInstanceProfile"

// AssociateIamInstanceProfileRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Associates an IAM instance profile with a running or stopped instance. You
// cannot associate more than one IAM instance profile with an instance.
//
//    // Example sending a request using AssociateIamInstanceProfileRequest.
//    req := client.AssociateIamInstanceProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile
func (c *Client) AssociateIamInstanceProfileRequest(input *AssociateIamInstanceProfileInput) AssociateIamInstanceProfileRequest {
	op := &aws.Operation{
		Name:       opAssociateIamInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIamInstanceProfileInput{}
	}

	req := c.newRequest(op, input, &AssociateIamInstanceProfileOutput{})

	return AssociateIamInstanceProfileRequest{Request: req, Input: input, Copy: c.AssociateIamInstanceProfileRequest}
}

// AssociateIamInstanceProfileRequest is the request type for the
// AssociateIamInstanceProfile API operation.
type AssociateIamInstanceProfileRequest struct {
	*aws.Request
	Input *AssociateIamInstanceProfileInput
	Copy  func(*AssociateIamInstanceProfileInput) AssociateIamInstanceProfileRequest
}

// Send marshals and sends the AssociateIamInstanceProfile API request.
func (r AssociateIamInstanceProfileRequest) Send(ctx context.Context) (*AssociateIamInstanceProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateIamInstanceProfileResponse{
		AssociateIamInstanceProfileOutput: r.Request.Data.(*AssociateIamInstanceProfileOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateIamInstanceProfileResponse is the response type for the
// AssociateIamInstanceProfile API operation.
type AssociateIamInstanceProfileResponse struct {
	*AssociateIamInstanceProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateIamInstanceProfile request.
func (r *AssociateIamInstanceProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
