// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateBackupInput struct {
	_ struct{} `type:"structure"`

	// Specified name for the backup.
	//
	// BackupName is a required field
	BackupName *string `min:"3" type:"string" required:"true"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBackupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBackupInput"}

	if s.BackupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupName"))
	}
	if s.BackupName != nil && len(*s.BackupName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("BackupName", 3))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateBackupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the backup created for the table.
	BackupDetails *BackupDetails `type:"structure"`
}

// String returns the string representation
func (s CreateBackupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateBackup = "CreateBackup"

// CreateBackupRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Creates a backup for an existing table.
//
// Each time you create an on-demand backup, the entire table data is backed
// up. There is no limit to the number of on-demand backups that can be taken.
//
// When you create an on-demand backup, a time marker of the request is cataloged,
// and the backup is created asynchronously, by applying all changes until the
// time of the request to the last full table snapshot. Backup requests are
// processed instantaneously and become available for restore within minutes.
//
// You can call CreateBackup at a maximum rate of 50 times per second.
//
// All backups in DynamoDB work without consuming any provisioned throughput
// on the table.
//
// If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed
// to contain all data committed to the table up to 14:24:00, and data committed
// after 14:26:00 will not be. The backup might contain data modifications made
// between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency.
//
// Along with data, the following are also included on the backups:
//
//    * Global secondary indexes (GSIs)
//
//    * Local secondary indexes (LSIs)
//
//    * Streams
//
//    * Provisioned read and write capacity
//
//    // Example sending a request using CreateBackupRequest.
//    req := client.CreateBackupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateBackup
func (c *Client) CreateBackupRequest(input *CreateBackupInput) CreateBackupRequest {
	op := &aws.Operation{
		Name:       opCreateBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBackupInput{}
	}

	req := c.newRequest(op, input, &CreateBackupOutput{})

	if req.Config.EnableEndpointDiscovery {
		de := discovererDescribeEndpoints{
			Client:        c,
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": &req.Operation.Name,
			},
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(aws.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}

	return CreateBackupRequest{Request: req, Input: input, Copy: c.CreateBackupRequest}
}

// CreateBackupRequest is the request type for the
// CreateBackup API operation.
type CreateBackupRequest struct {
	*aws.Request
	Input *CreateBackupInput
	Copy  func(*CreateBackupInput) CreateBackupRequest
}

// Send marshals and sends the CreateBackup API request.
func (r CreateBackupRequest) Send(ctx context.Context) (*CreateBackupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateBackupResponse{
		CreateBackupOutput: r.Request.Data.(*CreateBackupOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateBackupResponse is the response type for the
// CreateBackup API operation.
type CreateBackupResponse struct {
	*CreateBackupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateBackup request.
func (r *CreateBackupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
