// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDomainControllersInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory for which to retrieve the domain controller information.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A list of identifiers for the domain controllers whose information will be
	// provided.
	DomainControllerIds []string `type:"list"`

	// The maximum number of items to return.
	Limit *int64 `type:"integer"`

	// The DescribeDomainControllers.NextToken value from a previous call to DescribeDomainControllers.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDomainControllersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainControllersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDomainControllersInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDomainControllersOutput struct {
	_ struct{} `type:"structure"`

	// List of the DomainController objects that were retrieved.
	DomainControllers []DomainController `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeDomainControllers retrieve the
	// next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDomainControllersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDomainControllers = "DescribeDomainControllers"

// DescribeDomainControllersRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Provides information about any domain controllers in your directory.
//
//    // Example sending a request using DescribeDomainControllersRequest.
//    req := client.DescribeDomainControllersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers
func (c *Client) DescribeDomainControllersRequest(input *DescribeDomainControllersInput) DescribeDomainControllersRequest {
	op := &aws.Operation{
		Name:       opDescribeDomainControllers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDomainControllersInput{}
	}

	req := c.newRequest(op, input, &DescribeDomainControllersOutput{})

	return DescribeDomainControllersRequest{Request: req, Input: input, Copy: c.DescribeDomainControllersRequest}
}

// DescribeDomainControllersRequest is the request type for the
// DescribeDomainControllers API operation.
type DescribeDomainControllersRequest struct {
	*aws.Request
	Input *DescribeDomainControllersInput
	Copy  func(*DescribeDomainControllersInput) DescribeDomainControllersRequest
}

// Send marshals and sends the DescribeDomainControllers API request.
func (r DescribeDomainControllersRequest) Send(ctx context.Context) (*DescribeDomainControllersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDomainControllersResponse{
		DescribeDomainControllersOutput: r.Request.Data.(*DescribeDomainControllersOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeDomainControllersRequestPaginator returns a paginator for DescribeDomainControllers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeDomainControllersRequest(input)
//   p := directoryservice.NewDescribeDomainControllersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeDomainControllersPaginator(req DescribeDomainControllersRequest) DescribeDomainControllersPaginator {
	return DescribeDomainControllersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeDomainControllersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeDomainControllersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeDomainControllersPaginator struct {
	aws.Pager
}

func (p *DescribeDomainControllersPaginator) CurrentPage() *DescribeDomainControllersOutput {
	return p.Pager.CurrentPage().(*DescribeDomainControllersOutput)
}

// DescribeDomainControllersResponse is the response type for the
// DescribeDomainControllers API operation.
type DescribeDomainControllersResponse struct {
	*DescribeDomainControllersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDomainControllers request.
func (r *DescribeDomainControllersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
