// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateConnectionFromLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The ID of the LAG.
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateConnectionFromLagInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectionFromLagInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateConnectionFromLagInput"}

	if s.ConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionId"))
	}

	if s.LagId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about an AWS Direct Connect connection.
type DisassociateConnectionFromLagOutput struct {
	_ struct{} `type:"structure"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The bandwidth of the connection.
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The name of the connection.
	ConnectionName *string `locationName:"connectionName" type:"string"`

	// The state of the connection. The following are the possible values:
	//
	//    * ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * pending: The connection has been approved and is being initialized.
	//
	//    * available: The network link is up and the connection is ready for use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The connection is being deleted.
	//
	//    * deleted: The connection has been deleted.
	//
	//    * rejected: A hosted connection in the ordering state enters the rejected
	//    state if it is deleted by the customer.
	//
	//    * unknown: The state of the connection is not available.
	ConnectionState ConnectionState `locationName:"connectionState" type:"string" enum:"true"`

	// Indicates whether the connection supports a secondary BGP peer in the same
	// address family (IPv4/IPv6).
	HasLogicalRedundancy HasLogicalRedundancy `locationName:"hasLogicalRedundancy" type:"string" enum:"true"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeLoa for this connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The ID of the AWS account that owns the connection.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the AWS Direct Connect service provider associated with the connection.
	PartnerName *string `locationName:"partnerName" type:"string"`

	// The name of the service provider associated with the connection.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the connection.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s DisassociateConnectionFromLagOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateConnectionFromLag = "DisassociateConnectionFromLag"

// DisassociateConnectionFromLagRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Disassociates a connection from a link aggregation group (LAG). The connection
// is interrupted and re-established as a standalone connection (the connection
// is not deleted; to delete the connection, use the DeleteConnection request).
// If the LAG has associated virtual interfaces or hosted connections, they
// remain associated with the LAG. A disassociated connection owned by an AWS
// Direct Connect Partner is automatically converted to an interconnect.
//
// If disassociating the connection would cause the LAG to fall below its setting
// for minimum number of operational connections, the request fails, except
// when it's the last member of the LAG. If all connections are disassociated,
// the LAG continues to exist as an empty LAG with no physical connections.
//
//    // Example sending a request using DisassociateConnectionFromLagRequest.
//    req := client.DisassociateConnectionFromLagRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag
func (c *Client) DisassociateConnectionFromLagRequest(input *DisassociateConnectionFromLagInput) DisassociateConnectionFromLagRequest {
	op := &aws.Operation{
		Name:       opDisassociateConnectionFromLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectionFromLagInput{}
	}

	req := c.newRequest(op, input, &DisassociateConnectionFromLagOutput{})

	return DisassociateConnectionFromLagRequest{Request: req, Input: input, Copy: c.DisassociateConnectionFromLagRequest}
}

// DisassociateConnectionFromLagRequest is the request type for the
// DisassociateConnectionFromLag API operation.
type DisassociateConnectionFromLagRequest struct {
	*aws.Request
	Input *DisassociateConnectionFromLagInput
	Copy  func(*DisassociateConnectionFromLagInput) DisassociateConnectionFromLagRequest
}

// Send marshals and sends the DisassociateConnectionFromLag API request.
func (r DisassociateConnectionFromLagRequest) Send(ctx context.Context) (*DisassociateConnectionFromLagResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateConnectionFromLagResponse{
		DisassociateConnectionFromLagOutput: r.Request.Data.(*DisassociateConnectionFromLagOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateConnectionFromLagResponse is the response type for the
// DisassociateConnectionFromLag API operation.
type DisassociateConnectionFromLagResponse struct {
	*DisassociateConnectionFromLagOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateConnectionFromLag request.
func (r *DisassociateConnectionFromLagResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
