// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// The connections.
	Connections []Connection `locationName:"connections" type:"list"`
}

// String returns the string representation
func (s DescribeConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Displays the specified connection or all connections in this Region.
//
//    // Example sending a request using DescribeConnectionsRequest.
//    req := client.DescribeConnectionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections
func (c *Client) DescribeConnectionsRequest(input *DescribeConnectionsInput) DescribeConnectionsRequest {
	op := &aws.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	req := c.newRequest(op, input, &DescribeConnectionsOutput{})

	return DescribeConnectionsRequest{Request: req, Input: input, Copy: c.DescribeConnectionsRequest}
}

// DescribeConnectionsRequest is the request type for the
// DescribeConnections API operation.
type DescribeConnectionsRequest struct {
	*aws.Request
	Input *DescribeConnectionsInput
	Copy  func(*DescribeConnectionsInput) DescribeConnectionsRequest
}

// Send marshals and sends the DescribeConnections API request.
func (r DescribeConnectionsRequest) Send(ctx context.Context) (*DescribeConnectionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConnectionsResponse{
		DescribeConnectionsOutput: r.Request.Data.(*DescribeConnectionsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConnectionsResponse is the response type for the
// DescribeConnections API operation.
type DescribeConnectionsResponse struct {
	*DescribeConnectionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConnections request.
func (r *DescribeConnectionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
