// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTestGridSessionInput struct {
	_ struct{} `type:"structure"`

	// The ARN for the project that this session belongs to. See CreateTestGridProject
	// and ListTestGridProjects.
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string"`

	// An ARN that uniquely identifies a TestGridSession.
	SessionArn *string `locationName:"sessionArn" min:"32" type:"string"`

	// An ID associated with this session.
	SessionId *string `locationName:"sessionId" min:"1" type:"string"`
}

// String returns the string representation
func (s GetTestGridSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestGridSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTestGridSessionInput"}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.SessionArn != nil && len(*s.SessionArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("SessionArn", 32))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTestGridSessionOutput struct {
	_ struct{} `type:"structure"`

	// The TestGridSession that was requested.
	TestGridSession *TestGridSession `locationName:"testGridSession" type:"structure"`
}

// String returns the string representation
func (s GetTestGridSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTestGridSession = "GetTestGridSession"

// GetTestGridSessionRequest returns a request value for making API operation for
// AWS Device Farm.
//
// A session is an instance of a browser created through a RemoteWebDriver with
// the URL from CreateTestGridUrlResult$url. You can use the following to look
// up sessions:
//
//    * The session ARN (GetTestGridSessionRequest$sessionArn).
//
//    * The project ARN and a session ID (GetTestGridSessionRequest$projectArn
//    and GetTestGridSessionRequest$sessionId).
//
//    // Example sending a request using GetTestGridSessionRequest.
//    req := client.GetTestGridSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridSession
func (c *Client) GetTestGridSessionRequest(input *GetTestGridSessionInput) GetTestGridSessionRequest {
	op := &aws.Operation{
		Name:       opGetTestGridSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTestGridSessionInput{}
	}

	req := c.newRequest(op, input, &GetTestGridSessionOutput{})

	return GetTestGridSessionRequest{Request: req, Input: input, Copy: c.GetTestGridSessionRequest}
}

// GetTestGridSessionRequest is the request type for the
// GetTestGridSession API operation.
type GetTestGridSessionRequest struct {
	*aws.Request
	Input *GetTestGridSessionInput
	Copy  func(*GetTestGridSessionInput) GetTestGridSessionRequest
}

// Send marshals and sends the GetTestGridSession API request.
func (r GetTestGridSessionRequest) Send(ctx context.Context) (*GetTestGridSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTestGridSessionResponse{
		GetTestGridSessionOutput: r.Request.Data.(*GetTestGridSessionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTestGridSessionResponse is the response type for the
// GetTestGridSession API operation.
type GetTestGridSessionResponse struct {
	*GetTestGridSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTestGridSession request.
func (r *GetTestGridSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
