// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the get device pool operation.
type GetDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The device pool's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePoolInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDevicePoolInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a get device pool request.
type GetDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the requested device pool.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation
func (s GetDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDevicePool = "GetDevicePool"

// GetDevicePoolRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about a device pool.
//
//    // Example sending a request using GetDevicePoolRequest.
//    req := client.GetDevicePoolRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool
func (c *Client) GetDevicePoolRequest(input *GetDevicePoolInput) GetDevicePoolRequest {
	op := &aws.Operation{
		Name:       opGetDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevicePoolInput{}
	}

	req := c.newRequest(op, input, &GetDevicePoolOutput{})

	return GetDevicePoolRequest{Request: req, Input: input, Copy: c.GetDevicePoolRequest}
}

// GetDevicePoolRequest is the request type for the
// GetDevicePool API operation.
type GetDevicePoolRequest struct {
	*aws.Request
	Input *GetDevicePoolInput
	Copy  func(*GetDevicePoolInput) GetDevicePoolRequest
}

// Send marshals and sends the GetDevicePool API request.
func (r GetDevicePoolRequest) Send(ctx context.Context) (*GetDevicePoolResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDevicePoolResponse{
		GetDevicePoolOutput: r.Request.Data.(*GetDevicePoolOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDevicePoolResponse is the response type for the
// GetDevicePool API operation.
type GetDevicePoolResponse struct {
	*GetDevicePoolOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDevicePool request.
func (r *GetDevicePoolResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
