// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTestGridProjectInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the project to delete, from CreateTestGridProject or ListTestGridProjects.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTestGridProjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestGridProjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTestGridProjectInput"}

	if s.ProjectArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTestGridProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTestGridProjectOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTestGridProject = "DeleteTestGridProject"

// DeleteTestGridProjectRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Deletes a Selenium testing project and all content generated under it.
//
// You cannot undo this operation.
//
// You cannot delete a project if it has active sessions.
//
//    // Example sending a request using DeleteTestGridProjectRequest.
//    req := client.DeleteTestGridProjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteTestGridProject
func (c *Client) DeleteTestGridProjectRequest(input *DeleteTestGridProjectInput) DeleteTestGridProjectRequest {
	op := &aws.Operation{
		Name:       opDeleteTestGridProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTestGridProjectInput{}
	}

	req := c.newRequest(op, input, &DeleteTestGridProjectOutput{})

	return DeleteTestGridProjectRequest{Request: req, Input: input, Copy: c.DeleteTestGridProjectRequest}
}

// DeleteTestGridProjectRequest is the request type for the
// DeleteTestGridProject API operation.
type DeleteTestGridProjectRequest struct {
	*aws.Request
	Input *DeleteTestGridProjectInput
	Copy  func(*DeleteTestGridProjectInput) DeleteTestGridProjectRequest
}

// Send marshals and sends the DeleteTestGridProject API request.
func (r DeleteTestGridProjectRequest) Send(ctx context.Context) (*DeleteTestGridProjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTestGridProjectResponse{
		DeleteTestGridProjectOutput: r.Request.Data.(*DeleteTestGridProjectOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTestGridProjectResponse is the response type for the
// DeleteTestGridProject API operation.
type DeleteTestGridProjectResponse struct {
	*DeleteTestGridProjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTestGridProject request.
func (r *DeleteTestGridProjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
