// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// CreateLocationSmbRequest
type CreateLocationSmbInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block
	// (SMB) location.
	//
	// AgentArns is a required field
	AgentArns []string `min:"1" type:"list" required:"true"`

	// The name of the Windows domain that the SMB server belongs to.
	Domain *string `type:"string"`

	// The mount options used by DataSync to access the SMB server.
	MountOptions *SmbMountOptions `type:"structure"`

	// The password of the user who can mount the share, has the permissions to
	// access files and folders in the SMB share.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// The name of the SMB server. This value is the IP address or Domain Name Service
	// (DNS) name of the SMB server. An agent that is installed on-premises uses
	// this hostname to mount the SMB server in a network.
	//
	// This name must either be DNS-compliant or must be an IP version 4 (IPv4)
	// address.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// The subdirectory in the SMB file system that is used to read data from the
	// SMB source location or write data to the SMB destination. The SMB path should
	// be a path that's exported by the SMB server, or a subdirectory of that path.
	// The path should be such that it can be mounted by other SMB clients in your
	// network.
	//
	// Subdirectory must be specified with forward slashes. For example /path/to/folder.
	//
	// To transfer all the data in the folder you specified, DataSync needs to have
	// permissions to mount the SMB share, as well as to access all the data in
	// that share. To ensure this, either ensure that the user/password specified
	// belongs to the user who can mount the share, and who has the appropriate
	// permissions for all of the files and directories that you want DataSync to
	// access, or use credentials of a member of the Backup Operators group to mount
	// the share. Doing either enables the agent to access the data. For the agent
	// to access directories, you must additionally enable all execute access.
	//
	// Subdirectory is a required field
	Subdirectory *string `type:"string" required:"true"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []TagListEntry `type:"list"`

	// The user who can mount the share, has the permissions to access files and
	// folders in the SMB share.
	//
	// User is a required field
	User *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLocationSmbInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationSmbInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLocationSmbInput"}

	if s.AgentArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AgentArns", 1))
	}

	if s.Password == nil {
		invalidParams.Add(aws.NewErrParamRequired("Password"))
	}

	if s.ServerHostname == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerHostname"))
	}

	if s.Subdirectory == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subdirectory"))
	}

	if s.User == nil {
		invalidParams.Add(aws.NewErrParamRequired("User"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// CreateLocationSmbResponse
type CreateLocationSmbOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source SMB file system location that
	// is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLocationSmbOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateLocationSmb = "CreateLocationSmb"

// CreateLocationSmbRequest returns a request value for making API operation for
// AWS DataSync.
//
// Defines a file system on an Server Message Block (SMB) server that can be
// read from or written to.
//
//    // Example sending a request using CreateLocationSmbRequest.
//    req := client.CreateLocationSmbRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb
func (c *Client) CreateLocationSmbRequest(input *CreateLocationSmbInput) CreateLocationSmbRequest {
	op := &aws.Operation{
		Name:       opCreateLocationSmb,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationSmbInput{}
	}

	req := c.newRequest(op, input, &CreateLocationSmbOutput{})

	return CreateLocationSmbRequest{Request: req, Input: input, Copy: c.CreateLocationSmbRequest}
}

// CreateLocationSmbRequest is the request type for the
// CreateLocationSmb API operation.
type CreateLocationSmbRequest struct {
	*aws.Request
	Input *CreateLocationSmbInput
	Copy  func(*CreateLocationSmbInput) CreateLocationSmbRequest
}

// Send marshals and sends the CreateLocationSmb API request.
func (r CreateLocationSmbRequest) Send(ctx context.Context) (*CreateLocationSmbResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLocationSmbResponse{
		CreateLocationSmbOutput: r.Request.Data.(*CreateLocationSmbOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLocationSmbResponse is the response type for the
// CreateLocationSmb API operation.
type CreateLocationSmbResponse struct {
	*CreateLocationSmbOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLocationSmb request.
func (r *CreateLocationSmbResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
