// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The destination for the asset.
type AssetDestinationEntry struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the asset.
	//
	// AssetId is a required field
	AssetId *string `type:"string" required:"true"`

	// The S3 bucket that is the destination for the asset.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The name of the object in Amazon S3 for the asset.
	Key *string `type:"string"`
}

// String returns the string representation
func (s AssetDestinationEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetDestinationEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssetDestinationEntry"}

	if s.AssetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetId"))
	}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetDestinationEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AssetDetails struct {
	_ struct{} `type:"structure"`

	// The S3 object that is the asset.
	S3SnapshotAsset *S3SnapshotAsset `type:"structure"`
}

// String returns the string representation
func (s AssetDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3SnapshotAsset != nil {
		v := s.S3SnapshotAsset

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3SnapshotAsset", v, metadata)
	}
	return nil
}

// An asset in AWS Data Exchange is a piece of data that can be stored as an
// S3 object. The asset can be a structured data file, an image file, or some
// other data file. When you create an import job for your files, you create
// an asset in AWS Data Exchange for each of those files.
type AssetEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the asset.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Information about the asset, including its size.
	//
	// AssetDetails is a required field
	AssetDetails *AssetDetails `type:"structure" required:"true"`

	// The type of file your data is stored in. Currently, the supported asset type
	// is S3_SNAPSHOT.
	//
	// AssetType is a required field
	AssetType AssetType `type:"string" required:"true" enum:"true"`

	// The date and time that the asset was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier for the data set associated with this asset.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the asset.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name. When exporting to Amazon S3, the asset name is used
	// as default target S3 object key.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this asset.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The asset ID of the owned asset corresponding to the entitled asset being
	// viewed. This parameter is returned when an asset owner is viewing the entitled
	// copy of its owned asset.
	SourceId *string `type:"string"`

	// The date and time that the asset was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s AssetEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetDetails != nil {
		v := s.AssetDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AssetDetails", v, metadata)
	}
	if len(s.AssetType) > 0 {
		v := s.AssetType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceId != nil {
		v := *s.SourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The source of the assets.
type AssetSourceEntry struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that's part of the source of the asset.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The name of the object in Amazon S3 for the asset.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssetSourceEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetSourceEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssetSourceEntry"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssetSourceEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A data set is an AWS resource with one or more revisions.
type DataSetEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the data set.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The type of file your data is stored in. Currently, the supported asset type
	// is S3_SNAPSHOT.
	//
	// AssetType is a required field
	AssetType AssetType `type:"string" required:"true" enum:"true"`

	// The date and time that the data set was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description for the data set.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The unique identifier for the data set.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name of the data set.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A property that defines the data set as OWNED by the account (for providers)
	// or ENTITLED to the account (for subscribers).
	//
	// Origin is a required field
	Origin Origin `type:"string" required:"true" enum:"true"`

	// If the origin of this data set is ENTITLED, includes the details for the
	// product on AWS Marketplace.
	OriginDetails *OriginDetails `type:"structure"`

	// The data set ID of the owned data set corresponding to the entitled data
	// set being viewed. This parameter is returned when a data set owner is viewing
	// the entitled copy of its owned data set.
	SourceId *string `type:"string"`

	// The date and time that the data set was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DataSetEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSetEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AssetType) > 0 {
		v := s.AssetType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Origin) > 0 {
		v := s.Origin

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Origin", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OriginDetails != nil {
		v := s.OriginDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OriginDetails", v, metadata)
	}
	if s.SourceId != nil {
		v := *s.SourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

type Details struct {
	_ struct{} `type:"structure"`

	ImportAssetFromSignedUrlJobErrorDetails *ImportAssetFromSignedUrlJobErrorDetails `type:"structure"`

	// The list of sources for the assets.
	ImportAssetsFromS3JobErrorDetails []AssetSourceEntry `type:"list"`
}

// String returns the string representation
func (s Details) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Details) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImportAssetFromSignedUrlJobErrorDetails != nil {
		v := s.ImportAssetFromSignedUrlJobErrorDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ImportAssetFromSignedUrlJobErrorDetails", v, metadata)
	}
	if s.ImportAssetsFromS3JobErrorDetails != nil {
		v := s.ImportAssetsFromS3JobErrorDetails

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ImportAssetsFromS3JobErrorDetails", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Details of the operation to be performed by the job.
type ExportAssetToSignedUrlRequestDetails struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the asset that is exported to a signed URL.
	//
	// AssetId is a required field
	AssetId *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this export request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExportAssetToSignedUrlRequestDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportAssetToSignedUrlRequestDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportAssetToSignedUrlRequestDetails"}

	if s.AssetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetId"))
	}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportAssetToSignedUrlRequestDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details of the export to signed URL response.
type ExportAssetToSignedUrlResponseDetails struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the asset associated with this export job.
	//
	// AssetId is a required field
	AssetId *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this export response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The signed URL for the export request.
	SignedUrl *string `type:"string"`

	// The date and time that the signed URL expires, in ISO 8601 format.
	SignedUrlExpiresAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ExportAssetToSignedUrlResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportAssetToSignedUrlResponseDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SignedUrl != nil {
		v := *s.SignedUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SignedUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SignedUrlExpiresAt != nil {
		v := *s.SignedUrlExpiresAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SignedUrlExpiresAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Details of the operation to be performed by the job.
type ExportAssetsToS3RequestDetails struct {
	_ struct{} `type:"structure"`

	// The destination for the asset.
	//
	// AssetDestinations is a required field
	AssetDestinations []AssetDestinationEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Encryption configuration for the export job.
	Encryption *ExportServerSideEncryption `type:"structure"`

	// The unique identifier for the revision associated with this export request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExportAssetsToS3RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportAssetsToS3RequestDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportAssetsToS3RequestDetails"}

	if s.AssetDestinations == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetDestinations"))
	}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}
	if s.AssetDestinations != nil {
		for i, v := range s.AssetDestinations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetDestinations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportAssetsToS3RequestDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetDestinations != nil {
		v := s.AssetDestinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AssetDestinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the export to Amazon S3 response.
type ExportAssetsToS3ResponseDetails struct {
	_ struct{} `type:"structure"`

	// The destination in Amazon S3 where the asset is exported.
	//
	// AssetDestinations is a required field
	AssetDestinations []AssetDestinationEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Encryption configuration of the export job.
	Encryption *ExportServerSideEncryption `type:"structure"`

	// The unique identifier for the revision associated with this export response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExportAssetsToS3ResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportAssetsToS3ResponseDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetDestinations != nil {
		v := s.AssetDestinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AssetDestinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Encryption configuration of the export job. Includes the encryption type
// as well as the AWS KMS key. The KMS key is only necessary if you chose the
// KMS encryption type.
type ExportServerSideEncryption struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the the AWS KMS key you want to use to
	// encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms
	// as an encryption type.
	KmsKeyArn *string `type:"string"`

	// The type of server side encryption used for encrypting the objects in Amazon
	// S3.
	//
	// Type is a required field
	Type ServerSideEncryptionTypes `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ExportServerSideEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportServerSideEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportServerSideEncryption"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportServerSideEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.KmsKeyArn != nil {
		v := *s.KmsKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ImportAssetFromSignedUrlJobErrorDetails struct {
	_ struct{} `type:"structure"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name. When exporting to Amazon S3, the asset name is used
	// as default target S3 object key.
	//
	// AssetName is a required field
	AssetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportAssetFromSignedUrlJobErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportAssetFromSignedUrlJobErrorDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetName != nil {
		v := *s.AssetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details of the operation to be performed by the job.
type ImportAssetFromSignedUrlRequestDetails struct {
	_ struct{} `type:"structure"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name.
	//
	// AssetName is a required field
	AssetName *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The Base64-encoded Md5 hash for the asset, used to ensure the integrity of
	// the file at that location.
	//
	// Md5Hash is a required field
	Md5Hash *string `min:"24" type:"string" required:"true"`

	// The unique identifier for the revision associated with this import request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportAssetFromSignedUrlRequestDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportAssetFromSignedUrlRequestDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportAssetFromSignedUrlRequestDetails"}

	if s.AssetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetName"))
	}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if s.Md5Hash == nil {
		invalidParams.Add(aws.NewErrParamRequired("Md5Hash"))
	}
	if s.Md5Hash != nil && len(*s.Md5Hash) < 24 {
		invalidParams.Add(aws.NewErrParamMinLen("Md5Hash", 24))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportAssetFromSignedUrlRequestDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetName != nil {
		v := *s.AssetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Md5Hash != nil {
		v := *s.Md5Hash

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Md5Hash", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details in the response for an import request, including the signed URL
// and other information.
type ImportAssetFromSignedUrlResponseDetails struct {
	_ struct{} `type:"structure"`

	// The name for the asset associated with this import response.
	//
	// AssetName is a required field
	AssetName *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The Base64-encoded Md5 hash for the asset, used to ensure the integrity of
	// the file at that location.
	Md5Hash *string `min:"24" type:"string"`

	// The unique identifier for the revision associated with this import response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The signed URL.
	SignedUrl *string `type:"string"`

	// The time and date at which the signed URL expires, in ISO 8601 format.
	SignedUrlExpiresAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ImportAssetFromSignedUrlResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportAssetFromSignedUrlResponseDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetName != nil {
		v := *s.AssetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Md5Hash != nil {
		v := *s.Md5Hash

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Md5Hash", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SignedUrl != nil {
		v := *s.SignedUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SignedUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SignedUrlExpiresAt != nil {
		v := *s.SignedUrlExpiresAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SignedUrlExpiresAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Details of the operation to be performed by the job.
type ImportAssetsFromS3RequestDetails struct {
	_ struct{} `type:"structure"`

	// Is a list of S3 bucket and object key pairs.
	//
	// AssetSources is a required field
	AssetSources []AssetSourceEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this import request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportAssetsFromS3RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportAssetsFromS3RequestDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportAssetsFromS3RequestDetails"}

	if s.AssetSources == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetSources"))
	}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}
	if s.AssetSources != nil {
		for i, v := range s.AssetSources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetSources", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportAssetsFromS3RequestDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetSources != nil {
		v := s.AssetSources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AssetSources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details from an import from Amazon S3 response.
type ImportAssetsFromS3ResponseDetails struct {
	_ struct{} `type:"structure"`

	// Is a list of Amazon S3 bucket and object key pairs.
	//
	// AssetSources is a required field
	AssetSources []AssetSourceEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this import response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportAssetsFromS3ResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportAssetsFromS3ResponseDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetSources != nil {
		v := s.AssetSources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AssetSources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// AWS Data Exchange Jobs are asynchronous import or export operations used
// to create or copy assets. A data set owner can both import and export as
// they see fit. Someone with an entitlement to a data set can only export.
// Jobs are deleted 90 days after they are created.
type JobEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date and time that the job was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Details of the operation to be performed by the job, such as export destination
	// details or import source details.
	//
	// Details is a required field
	Details *ResponseDetails `type:"structure" required:"true"`

	// Errors for jobs.
	Errors []JobError `type:"list"`

	// The unique identifier for the job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The state of the job.
	//
	// State is a required field
	State State `type:"string" required:"true" enum:"true"`

	// The job type.
	//
	// Type is a required field
	Type Type `type:"string" required:"true" enum:"true"`

	// The date and time that the job was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s JobEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Details != nil {
		v := s.Details

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Details", v, metadata)
	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// An error that occurred with the job request.
type JobError struct {
	_ struct{} `type:"structure"`

	// The code for the job error.
	//
	// Code is a required field
	Code Code `type:"string" required:"true" enum:"true"`

	Details *Details `type:"structure"`

	// The name of the limit that was reached.
	LimitName JobErrorLimitName `type:"string" enum:"true"`

	// The value of the exceeded limit.
	LimitValue *float64 `type:"double"`

	// The message related to the job error.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The unique identifier for the resource related to the error.
	ResourceId *string `type:"string"`

	// The type of resource related to the error.
	ResourceType JobErrorResourceTypes `type:"string" enum:"true"`
}

// String returns the string representation
func (s JobError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobError) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Code) > 0 {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Code", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Details != nil {
		v := s.Details

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Details", v, metadata)
	}
	if len(s.LimitName) > 0 {
		v := s.LimitName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LimitName", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LimitValue != nil {
		v := *s.LimitValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LimitValue", protocol.Float64Value(v), metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type OriginDetails struct {
	_ struct{} `type:"structure"`

	// ProductId is a required field
	ProductId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProductId != nil {
		v := *s.ProductId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details for the request.
type RequestDetails struct {
	_ struct{} `type:"structure"`

	// Details about the export to signed URL request.
	ExportAssetToSignedUrl *ExportAssetToSignedUrlRequestDetails `type:"structure"`

	// Details about the export to Amazon S3 request.
	ExportAssetsToS3 *ExportAssetsToS3RequestDetails `type:"structure"`

	// Details about the import from signed URL request.
	ImportAssetFromSignedUrl *ImportAssetFromSignedUrlRequestDetails `type:"structure"`

	// Details about the import from Amazon S3 request.
	ImportAssetsFromS3 *ImportAssetsFromS3RequestDetails `type:"structure"`
}

// String returns the string representation
func (s RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestDetails"}
	if s.ExportAssetToSignedUrl != nil {
		if err := s.ExportAssetToSignedUrl.Validate(); err != nil {
			invalidParams.AddNested("ExportAssetToSignedUrl", err.(aws.ErrInvalidParams))
		}
	}
	if s.ExportAssetsToS3 != nil {
		if err := s.ExportAssetsToS3.Validate(); err != nil {
			invalidParams.AddNested("ExportAssetsToS3", err.(aws.ErrInvalidParams))
		}
	}
	if s.ImportAssetFromSignedUrl != nil {
		if err := s.ImportAssetFromSignedUrl.Validate(); err != nil {
			invalidParams.AddNested("ImportAssetFromSignedUrl", err.(aws.ErrInvalidParams))
		}
	}
	if s.ImportAssetsFromS3 != nil {
		if err := s.ImportAssetsFromS3.Validate(); err != nil {
			invalidParams.AddNested("ImportAssetsFromS3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RequestDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExportAssetToSignedUrl != nil {
		v := s.ExportAssetToSignedUrl

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ExportAssetToSignedUrl", v, metadata)
	}
	if s.ExportAssetsToS3 != nil {
		v := s.ExportAssetsToS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ExportAssetsToS3", v, metadata)
	}
	if s.ImportAssetFromSignedUrl != nil {
		v := s.ImportAssetFromSignedUrl

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ImportAssetFromSignedUrl", v, metadata)
	}
	if s.ImportAssetsFromS3 != nil {
		v := s.ImportAssetsFromS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ImportAssetsFromS3", v, metadata)
	}
	return nil
}

// Details for the response.
type ResponseDetails struct {
	_ struct{} `type:"structure"`

	// Details for the export to signed URL response.
	ExportAssetToSignedUrl *ExportAssetToSignedUrlResponseDetails `type:"structure"`

	// Details for the export to Amazon S3 response.
	ExportAssetsToS3 *ExportAssetsToS3ResponseDetails `type:"structure"`

	// Details for the import from signed URL response.
	ImportAssetFromSignedUrl *ImportAssetFromSignedUrlResponseDetails `type:"structure"`

	// Details for the import from Amazon S3 response.
	ImportAssetsFromS3 *ImportAssetsFromS3ResponseDetails `type:"structure"`
}

// String returns the string representation
func (s ResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResponseDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExportAssetToSignedUrl != nil {
		v := s.ExportAssetToSignedUrl

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ExportAssetToSignedUrl", v, metadata)
	}
	if s.ExportAssetsToS3 != nil {
		v := s.ExportAssetsToS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ExportAssetsToS3", v, metadata)
	}
	if s.ImportAssetFromSignedUrl != nil {
		v := s.ImportAssetFromSignedUrl

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ImportAssetFromSignedUrl", v, metadata)
	}
	if s.ImportAssetsFromS3 != nil {
		v := s.ImportAssetsFromS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ImportAssetsFromS3", v, metadata)
	}
	return nil
}

// A revision is a container for one or more assets.
type RevisionEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the revision.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// An optional comment about the revision.
	Comment *string `type:"string"`

	// The date and time that the revision was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier for the data set associated with this revision.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// To publish a revision to a data set in a product, the revision must first
	// be finalized. Finalizing a revision tells AWS Data Exchange that your changes
	// to the assets in the revision are complete. After it's in this read-only
	// state, you can publish the revision to your products.
	//
	// Finalized revisions can be published through the AWS Data Exchange console
	// or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace
	// Catalog API action. When using the API, revisions are uniquely identified
	// by their ARN.
	Finalized *bool `type:"boolean"`

	// The unique identifier for the revision.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The revision ID of the owned revision corresponding to the entitled revision
	// being viewed. This parameter is returned when a revision owner is viewing
	// the entitled copy of its owned revision.
	SourceId *string `type:"string"`

	// The date and time that the revision was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s RevisionEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RevisionEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Finalized != nil {
		v := *s.Finalized

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Finalized", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceId != nil {
		v := *s.SourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The S3 object that is the asset.
type S3SnapshotAsset struct {
	_ struct{} `type:"structure"`

	// The size of the S3 object that is the object.
	//
	// Size is a required field
	Size *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s S3SnapshotAsset) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3SnapshotAsset) MarshalFields(e protocol.FieldEncoder) error {
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Float64Value(v), metadata)
	}
	return nil
}
