// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCostCategoryDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The date when the Cost Category was effective.
	EffectiveOn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DescribeCostCategoryDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCostCategoryDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCostCategoryDefinitionInput"}

	if s.CostCategoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CostCategoryArn"))
	}
	if s.CostCategoryArn != nil && len(*s.CostCategoryArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CostCategoryArn", 20))
	}
	if s.EffectiveOn != nil && len(*s.EffectiveOn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("EffectiveOn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCostCategoryDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The structure of Cost Categories. This includes detailed metadata and the
	// set of rules for the CostCategory object.
	CostCategory *CostCategory `type:"structure"`
}

// String returns the string representation
func (s DescribeCostCategoryDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCostCategoryDefinition = "DescribeCostCategoryDefinition"

// DescribeCostCategoryDefinitionRequest returns a request value for making API operation for
// AWS Cost Explorer Service.
//
// Returns the name, ARN, rules, definition, and effective dates of a Cost Category
// that's defined in the account.
//
// You have the option to use EffectiveOn to return a Cost Category that is
// active on a specific date. If there is no EffectiveOn specified, you’ll
// see a Cost Category that is effective on the current date. If Cost Category
// is still effective, EffectiveEnd is omitted in the response.
//
//    // Example sending a request using DescribeCostCategoryDefinitionRequest.
//    req := client.DescribeCostCategoryDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition
func (c *Client) DescribeCostCategoryDefinitionRequest(input *DescribeCostCategoryDefinitionInput) DescribeCostCategoryDefinitionRequest {
	op := &aws.Operation{
		Name:       opDescribeCostCategoryDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCostCategoryDefinitionInput{}
	}

	req := c.newRequest(op, input, &DescribeCostCategoryDefinitionOutput{})

	return DescribeCostCategoryDefinitionRequest{Request: req, Input: input, Copy: c.DescribeCostCategoryDefinitionRequest}
}

// DescribeCostCategoryDefinitionRequest is the request type for the
// DescribeCostCategoryDefinition API operation.
type DescribeCostCategoryDefinitionRequest struct {
	*aws.Request
	Input *DescribeCostCategoryDefinitionInput
	Copy  func(*DescribeCostCategoryDefinitionInput) DescribeCostCategoryDefinitionRequest
}

// Send marshals and sends the DescribeCostCategoryDefinition API request.
func (r DescribeCostCategoryDefinitionRequest) Send(ctx context.Context) (*DescribeCostCategoryDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCostCategoryDefinitionResponse{
		DescribeCostCategoryDefinitionOutput: r.Request.Data.(*DescribeCostCategoryDefinitionOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCostCategoryDefinitionResponse is the response type for the
// DescribeCostCategoryDefinition API operation.
type DescribeCostCategoryDefinitionResponse struct {
	*DescribeCostCategoryDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCostCategoryDefinition request.
func (r *DescribeCostCategoryDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
