// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectparticipant

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetTranscriptInput struct {
	_ struct{} `type:"structure"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The contactId from the current contact chain for which transcript is needed.
	ContactId *string `min:"1" type:"string"`

	// The maximum number of results to return in the page. Default: 10.
	MaxResults *int64 `type:"integer"`

	// The pagination token. Use the value returned previously in the next subsequent
	// request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The direction from StartPosition from which to retrieve message. Default:
	// BACKWARD when no StartPosition is provided, FORWARD with StartPosition.
	ScanDirection ScanDirection `type:"string" enum:"true"`

	// The sort order for the records. Default: DESCENDING.
	SortOrder SortKey `type:"string" enum:"true"`

	// A filtering option for where to start.
	StartPosition *StartPosition `type:"structure"`
}

// String returns the string representation
func (s GetTranscriptInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTranscriptInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTranscriptInput"}

	if s.ConnectionToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContactId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.StartPosition != nil {
		if err := s.StartPosition.Validate(); err != nil {
			invalidParams.AddNested("StartPosition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetTranscriptInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ScanDirection) > 0 {
		v := s.ScanDirection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScanDirection", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SortOrder) > 0 {
		v := s.SortOrder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SortOrder", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartPosition != nil {
		v := s.StartPosition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StartPosition", v, metadata)
	}
	if s.ConnectionToken != nil {
		v := *s.ConnectionToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Bearer", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetTranscriptOutput struct {
	_ struct{} `type:"structure"`

	// The initial contact ID for the contact.
	InitialContactId *string `min:"1" type:"string"`

	// The pagination token. Use the value returned previously in the next subsequent
	// request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The list of messages in the session.
	Transcript []Item `type:"list"`
}

// String returns the string representation
func (s GetTranscriptOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetTranscriptOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InitialContactId != nil {
		v := *s.InitialContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InitialContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Transcript != nil {
		v := s.Transcript

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Transcript", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetTranscript = "GetTranscript"

// GetTranscriptRequest returns a request value for making API operation for
// Amazon Connect Participant Service.
//
// Retrieves a transcript of the session. Note that ConnectionToken is used
// for invoking this API instead of ParticipantToken.
//
//    // Example sending a request using GetTranscriptRequest.
//    req := client.GetTranscriptRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/GetTranscript
func (c *Client) GetTranscriptRequest(input *GetTranscriptInput) GetTranscriptRequest {
	op := &aws.Operation{
		Name:       opGetTranscript,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/transcript",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTranscriptInput{}
	}

	req := c.newRequest(op, input, &GetTranscriptOutput{})

	return GetTranscriptRequest{Request: req, Input: input, Copy: c.GetTranscriptRequest}
}

// GetTranscriptRequest is the request type for the
// GetTranscript API operation.
type GetTranscriptRequest struct {
	*aws.Request
	Input *GetTranscriptInput
	Copy  func(*GetTranscriptInput) GetTranscriptRequest
}

// Send marshals and sends the GetTranscript API request.
func (r GetTranscriptRequest) Send(ctx context.Context) (*GetTranscriptResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTranscriptResponse{
		GetTranscriptOutput: r.Request.Data.(*GetTranscriptOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetTranscriptRequestPaginator returns a paginator for GetTranscript.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetTranscriptRequest(input)
//   p := connectparticipant.NewGetTranscriptRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetTranscriptPaginator(req GetTranscriptRequest) GetTranscriptPaginator {
	return GetTranscriptPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetTranscriptInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetTranscriptPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetTranscriptPaginator struct {
	aws.Pager
}

func (p *GetTranscriptPaginator) CurrentPage() *GetTranscriptOutput {
	return p.Pager.CurrentPage().(*GetTranscriptOutput)
}

// GetTranscriptResponse is the response type for the
// GetTranscript API operation.
type GetTranscriptResponse struct {
	*GetTranscriptOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTranscript request.
func (r *GetTranscriptResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
