// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StopContactRecordingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the contact.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the contact. This is the identifier of the contact associated
	// with the first interaction with the contact center.
	//
	// InitialContactId is a required field
	InitialContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopContactRecordingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopContactRecordingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopContactRecordingInput"}

	if s.ContactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContactId", 1))
	}

	if s.InitialContactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InitialContactId"))
	}
	if s.InitialContactId != nil && len(*s.InitialContactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InitialContactId", 1))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopContactRecordingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InitialContactId != nil {
		v := *s.InitialContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InitialContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StopContactRecordingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopContactRecordingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopContactRecordingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opStopContactRecording = "StopContactRecording"

// StopContactRecordingRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// When a contact is being recorded, this API stops recording the call. StopContactRecording
// is a one-time action. If you use StopContactRecording to stop recording an
// ongoing call, you can't use StartContactRecording to restart it. For scenarios
// where the recording has started and you want to suspend it for sensitive
// information (for example, to collect a credit card number), and then restart
// it, use SuspendContactRecording and ResumeContactRecording.
//
// Only voice recordings are supported at this time.
//
//    // Example sending a request using StopContactRecordingRequest.
//    req := client.StopContactRecordingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactRecording
func (c *Client) StopContactRecordingRequest(input *StopContactRecordingInput) StopContactRecordingRequest {
	op := &aws.Operation{
		Name:       opStopContactRecording,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/stop-recording",
	}

	if input == nil {
		input = &StopContactRecordingInput{}
	}

	req := c.newRequest(op, input, &StopContactRecordingOutput{})

	return StopContactRecordingRequest{Request: req, Input: input, Copy: c.StopContactRecordingRequest}
}

// StopContactRecordingRequest is the request type for the
// StopContactRecording API operation.
type StopContactRecordingRequest struct {
	*aws.Request
	Input *StopContactRecordingInput
	Copy  func(*StopContactRecordingInput) StopContactRecordingRequest
}

// Send marshals and sends the StopContactRecording API request.
func (r StopContactRecordingRequest) Send(ctx context.Context) (*StopContactRecordingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopContactRecordingResponse{
		StopContactRecordingOutput: r.Request.Data.(*StopContactRecordingOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopContactRecordingResponse is the response type for the
// StopContactRecording API operation.
type StopContactRecordingResponse struct {
	*StopContactRecordingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopContactRecording request.
func (r *StopContactRecordingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
