// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package configserviceiface provides an interface to enable mocking the AWS Config service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package configserviceiface

import (
	"github.com/aws/aws-sdk-go-v2/service/configservice"
)

// ClientAPI provides an interface to enable mocking the
// configservice.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Config Service.
//    func myFunc(svc configserviceiface.ClientAPI) bool {
//        // Make svc.BatchGetAggregateResourceConfig request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := configservice.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        configserviceiface.ClientPI
//    }
//    func (m *mockClientClient) BatchGetAggregateResourceConfig(input *configservice.BatchGetAggregateResourceConfigInput) (*configservice.BatchGetAggregateResourceConfigOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchGetAggregateResourceConfigRequest(*configservice.BatchGetAggregateResourceConfigInput) configservice.BatchGetAggregateResourceConfigRequest

	BatchGetResourceConfigRequest(*configservice.BatchGetResourceConfigInput) configservice.BatchGetResourceConfigRequest

	DeleteAggregationAuthorizationRequest(*configservice.DeleteAggregationAuthorizationInput) configservice.DeleteAggregationAuthorizationRequest

	DeleteConfigRuleRequest(*configservice.DeleteConfigRuleInput) configservice.DeleteConfigRuleRequest

	DeleteConfigurationAggregatorRequest(*configservice.DeleteConfigurationAggregatorInput) configservice.DeleteConfigurationAggregatorRequest

	DeleteConfigurationRecorderRequest(*configservice.DeleteConfigurationRecorderInput) configservice.DeleteConfigurationRecorderRequest

	DeleteConformancePackRequest(*configservice.DeleteConformancePackInput) configservice.DeleteConformancePackRequest

	DeleteDeliveryChannelRequest(*configservice.DeleteDeliveryChannelInput) configservice.DeleteDeliveryChannelRequest

	DeleteEvaluationResultsRequest(*configservice.DeleteEvaluationResultsInput) configservice.DeleteEvaluationResultsRequest

	DeleteOrganizationConfigRuleRequest(*configservice.DeleteOrganizationConfigRuleInput) configservice.DeleteOrganizationConfigRuleRequest

	DeleteOrganizationConformancePackRequest(*configservice.DeleteOrganizationConformancePackInput) configservice.DeleteOrganizationConformancePackRequest

	DeletePendingAggregationRequestRequest(*configservice.DeletePendingAggregationRequestInput) configservice.DeletePendingAggregationRequestRequest

	DeleteRemediationConfigurationRequest(*configservice.DeleteRemediationConfigurationInput) configservice.DeleteRemediationConfigurationRequest

	DeleteRemediationExceptionsRequest(*configservice.DeleteRemediationExceptionsInput) configservice.DeleteRemediationExceptionsRequest

	DeleteResourceConfigRequest(*configservice.DeleteResourceConfigInput) configservice.DeleteResourceConfigRequest

	DeleteRetentionConfigurationRequest(*configservice.DeleteRetentionConfigurationInput) configservice.DeleteRetentionConfigurationRequest

	DeliverConfigSnapshotRequest(*configservice.DeliverConfigSnapshotInput) configservice.DeliverConfigSnapshotRequest

	DescribeAggregateComplianceByConfigRulesRequest(*configservice.DescribeAggregateComplianceByConfigRulesInput) configservice.DescribeAggregateComplianceByConfigRulesRequest

	DescribeAggregationAuthorizationsRequest(*configservice.DescribeAggregationAuthorizationsInput) configservice.DescribeAggregationAuthorizationsRequest

	DescribeComplianceByConfigRuleRequest(*configservice.DescribeComplianceByConfigRuleInput) configservice.DescribeComplianceByConfigRuleRequest

	DescribeComplianceByResourceRequest(*configservice.DescribeComplianceByResourceInput) configservice.DescribeComplianceByResourceRequest

	DescribeConfigRuleEvaluationStatusRequest(*configservice.DescribeConfigRuleEvaluationStatusInput) configservice.DescribeConfigRuleEvaluationStatusRequest

	DescribeConfigRulesRequest(*configservice.DescribeConfigRulesInput) configservice.DescribeConfigRulesRequest

	DescribeConfigurationAggregatorSourcesStatusRequest(*configservice.DescribeConfigurationAggregatorSourcesStatusInput) configservice.DescribeConfigurationAggregatorSourcesStatusRequest

	DescribeConfigurationAggregatorsRequest(*configservice.DescribeConfigurationAggregatorsInput) configservice.DescribeConfigurationAggregatorsRequest

	DescribeConfigurationRecorderStatusRequest(*configservice.DescribeConfigurationRecorderStatusInput) configservice.DescribeConfigurationRecorderStatusRequest

	DescribeConfigurationRecordersRequest(*configservice.DescribeConfigurationRecordersInput) configservice.DescribeConfigurationRecordersRequest

	DescribeConformancePackComplianceRequest(*configservice.DescribeConformancePackComplianceInput) configservice.DescribeConformancePackComplianceRequest

	DescribeConformancePackStatusRequest(*configservice.DescribeConformancePackStatusInput) configservice.DescribeConformancePackStatusRequest

	DescribeConformancePacksRequest(*configservice.DescribeConformancePacksInput) configservice.DescribeConformancePacksRequest

	DescribeDeliveryChannelStatusRequest(*configservice.DescribeDeliveryChannelStatusInput) configservice.DescribeDeliveryChannelStatusRequest

	DescribeDeliveryChannelsRequest(*configservice.DescribeDeliveryChannelsInput) configservice.DescribeDeliveryChannelsRequest

	DescribeOrganizationConfigRuleStatusesRequest(*configservice.DescribeOrganizationConfigRuleStatusesInput) configservice.DescribeOrganizationConfigRuleStatusesRequest

	DescribeOrganizationConfigRulesRequest(*configservice.DescribeOrganizationConfigRulesInput) configservice.DescribeOrganizationConfigRulesRequest

	DescribeOrganizationConformancePackStatusesRequest(*configservice.DescribeOrganizationConformancePackStatusesInput) configservice.DescribeOrganizationConformancePackStatusesRequest

	DescribeOrganizationConformancePacksRequest(*configservice.DescribeOrganizationConformancePacksInput) configservice.DescribeOrganizationConformancePacksRequest

	DescribePendingAggregationRequestsRequest(*configservice.DescribePendingAggregationRequestsInput) configservice.DescribePendingAggregationRequestsRequest

	DescribeRemediationConfigurationsRequest(*configservice.DescribeRemediationConfigurationsInput) configservice.DescribeRemediationConfigurationsRequest

	DescribeRemediationExceptionsRequest(*configservice.DescribeRemediationExceptionsInput) configservice.DescribeRemediationExceptionsRequest

	DescribeRemediationExecutionStatusRequest(*configservice.DescribeRemediationExecutionStatusInput) configservice.DescribeRemediationExecutionStatusRequest

	DescribeRetentionConfigurationsRequest(*configservice.DescribeRetentionConfigurationsInput) configservice.DescribeRetentionConfigurationsRequest

	GetAggregateComplianceDetailsByConfigRuleRequest(*configservice.GetAggregateComplianceDetailsByConfigRuleInput) configservice.GetAggregateComplianceDetailsByConfigRuleRequest

	GetAggregateConfigRuleComplianceSummaryRequest(*configservice.GetAggregateConfigRuleComplianceSummaryInput) configservice.GetAggregateConfigRuleComplianceSummaryRequest

	GetAggregateDiscoveredResourceCountsRequest(*configservice.GetAggregateDiscoveredResourceCountsInput) configservice.GetAggregateDiscoveredResourceCountsRequest

	GetAggregateResourceConfigRequest(*configservice.GetAggregateResourceConfigInput) configservice.GetAggregateResourceConfigRequest

	GetComplianceDetailsByConfigRuleRequest(*configservice.GetComplianceDetailsByConfigRuleInput) configservice.GetComplianceDetailsByConfigRuleRequest

	GetComplianceDetailsByResourceRequest(*configservice.GetComplianceDetailsByResourceInput) configservice.GetComplianceDetailsByResourceRequest

	GetComplianceSummaryByConfigRuleRequest(*configservice.GetComplianceSummaryByConfigRuleInput) configservice.GetComplianceSummaryByConfigRuleRequest

	GetComplianceSummaryByResourceTypeRequest(*configservice.GetComplianceSummaryByResourceTypeInput) configservice.GetComplianceSummaryByResourceTypeRequest

	GetConformancePackComplianceDetailsRequest(*configservice.GetConformancePackComplianceDetailsInput) configservice.GetConformancePackComplianceDetailsRequest

	GetConformancePackComplianceSummaryRequest(*configservice.GetConformancePackComplianceSummaryInput) configservice.GetConformancePackComplianceSummaryRequest

	GetDiscoveredResourceCountsRequest(*configservice.GetDiscoveredResourceCountsInput) configservice.GetDiscoveredResourceCountsRequest

	GetOrganizationConfigRuleDetailedStatusRequest(*configservice.GetOrganizationConfigRuleDetailedStatusInput) configservice.GetOrganizationConfigRuleDetailedStatusRequest

	GetOrganizationConformancePackDetailedStatusRequest(*configservice.GetOrganizationConformancePackDetailedStatusInput) configservice.GetOrganizationConformancePackDetailedStatusRequest

	GetResourceConfigHistoryRequest(*configservice.GetResourceConfigHistoryInput) configservice.GetResourceConfigHistoryRequest

	ListAggregateDiscoveredResourcesRequest(*configservice.ListAggregateDiscoveredResourcesInput) configservice.ListAggregateDiscoveredResourcesRequest

	ListDiscoveredResourcesRequest(*configservice.ListDiscoveredResourcesInput) configservice.ListDiscoveredResourcesRequest

	ListTagsForResourceRequest(*configservice.ListTagsForResourceInput) configservice.ListTagsForResourceRequest

	PutAggregationAuthorizationRequest(*configservice.PutAggregationAuthorizationInput) configservice.PutAggregationAuthorizationRequest

	PutConfigRuleRequest(*configservice.PutConfigRuleInput) configservice.PutConfigRuleRequest

	PutConfigurationAggregatorRequest(*configservice.PutConfigurationAggregatorInput) configservice.PutConfigurationAggregatorRequest

	PutConfigurationRecorderRequest(*configservice.PutConfigurationRecorderInput) configservice.PutConfigurationRecorderRequest

	PutConformancePackRequest(*configservice.PutConformancePackInput) configservice.PutConformancePackRequest

	PutDeliveryChannelRequest(*configservice.PutDeliveryChannelInput) configservice.PutDeliveryChannelRequest

	PutEvaluationsRequest(*configservice.PutEvaluationsInput) configservice.PutEvaluationsRequest

	PutOrganizationConfigRuleRequest(*configservice.PutOrganizationConfigRuleInput) configservice.PutOrganizationConfigRuleRequest

	PutOrganizationConformancePackRequest(*configservice.PutOrganizationConformancePackInput) configservice.PutOrganizationConformancePackRequest

	PutRemediationConfigurationsRequest(*configservice.PutRemediationConfigurationsInput) configservice.PutRemediationConfigurationsRequest

	PutRemediationExceptionsRequest(*configservice.PutRemediationExceptionsInput) configservice.PutRemediationExceptionsRequest

	PutResourceConfigRequest(*configservice.PutResourceConfigInput) configservice.PutResourceConfigRequest

	PutRetentionConfigurationRequest(*configservice.PutRetentionConfigurationInput) configservice.PutRetentionConfigurationRequest

	SelectAggregateResourceConfigRequest(*configservice.SelectAggregateResourceConfigInput) configservice.SelectAggregateResourceConfigRequest

	SelectResourceConfigRequest(*configservice.SelectResourceConfigInput) configservice.SelectResourceConfigRequest

	StartConfigRulesEvaluationRequest(*configservice.StartConfigRulesEvaluationInput) configservice.StartConfigRulesEvaluationRequest

	StartConfigurationRecorderRequest(*configservice.StartConfigurationRecorderInput) configservice.StartConfigurationRecorderRequest

	StartRemediationExecutionRequest(*configservice.StartRemediationExecutionInput) configservice.StartRemediationExecutionRequest

	StopConfigurationRecorderRequest(*configservice.StopConfigurationRecorderInput) configservice.StopConfigurationRecorderRequest

	TagResourceRequest(*configservice.TagResourceInput) configservice.TagResourceRequest

	UntagResourceRequest(*configservice.UntagResourceInput) configservice.UntagResourceRequest
}

var _ ClientAPI = (*configservice.Client)(nil)
