// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetComplianceSummaryByResourceTypeInput struct {
	_ struct{} `type:"structure"`

	// Specify one or more resource types to get the number of resources that are
	// compliant and the number that are noncompliant for each resource type.
	//
	// For this request, you can specify an AWS resource type such as AWS::EC2::Instance.
	// You can specify that the resource type is an AWS account by specifying AWS::::Account.
	ResourceTypes []string `type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryByResourceTypeInput) String() string {
	return awsutil.Prettify(s)
}

type GetComplianceSummaryByResourceTypeOutput struct {
	_ struct{} `type:"structure"`

	// The number of resources that are compliant and the number that are noncompliant.
	// If one or more resource types were provided with the request, the numbers
	// are returned for each resource type. The maximum number returned is 100.
	ComplianceSummariesByResourceType []ComplianceSummaryByResourceType `type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryByResourceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetComplianceSummaryByResourceType = "GetComplianceSummaryByResourceType"

// GetComplianceSummaryByResourceTypeRequest returns a request value for making API operation for
// AWS Config.
//
// Returns the number of resources that are compliant and the number that are
// noncompliant. You can specify one or more resource types to get these numbers
// for each resource type. The maximum number returned is 100.
//
//    // Example sending a request using GetComplianceSummaryByResourceTypeRequest.
//    req := client.GetComplianceSummaryByResourceTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType
func (c *Client) GetComplianceSummaryByResourceTypeRequest(input *GetComplianceSummaryByResourceTypeInput) GetComplianceSummaryByResourceTypeRequest {
	op := &aws.Operation{
		Name:       opGetComplianceSummaryByResourceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceSummaryByResourceTypeInput{}
	}

	req := c.newRequest(op, input, &GetComplianceSummaryByResourceTypeOutput{})

	return GetComplianceSummaryByResourceTypeRequest{Request: req, Input: input, Copy: c.GetComplianceSummaryByResourceTypeRequest}
}

// GetComplianceSummaryByResourceTypeRequest is the request type for the
// GetComplianceSummaryByResourceType API operation.
type GetComplianceSummaryByResourceTypeRequest struct {
	*aws.Request
	Input *GetComplianceSummaryByResourceTypeInput
	Copy  func(*GetComplianceSummaryByResourceTypeInput) GetComplianceSummaryByResourceTypeRequest
}

// Send marshals and sends the GetComplianceSummaryByResourceType API request.
func (r GetComplianceSummaryByResourceTypeRequest) Send(ctx context.Context) (*GetComplianceSummaryByResourceTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetComplianceSummaryByResourceTypeResponse{
		GetComplianceSummaryByResourceTypeOutput: r.Request.Data.(*GetComplianceSummaryByResourceTypeOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetComplianceSummaryByResourceTypeResponse is the response type for the
// GetComplianceSummaryByResourceType API operation.
type GetComplianceSummaryByResourceTypeResponse struct {
	*GetComplianceSummaryByResourceTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetComplianceSummaryByResourceType request.
func (r *GetComplianceSummaryByResourceTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
