// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeRemediationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A list of AWS Config rule names of remediation configurations for which you
	// want details.
	//
	// ConfigRuleNames is a required field
	ConfigRuleNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeRemediationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRemediationConfigurationsInput"}

	if s.ConfigRuleNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigRuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeRemediationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a remediation configuration object.
	RemediationConfigurations []RemediationConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeRemediationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeRemediationConfigurations = "DescribeRemediationConfigurations"

// DescribeRemediationConfigurationsRequest returns a request value for making API operation for
// AWS Config.
//
// Returns the details of one or more remediation configurations.
//
//    // Example sending a request using DescribeRemediationConfigurationsRequest.
//    req := client.DescribeRemediationConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations
func (c *Client) DescribeRemediationConfigurationsRequest(input *DescribeRemediationConfigurationsInput) DescribeRemediationConfigurationsRequest {
	op := &aws.Operation{
		Name:       opDescribeRemediationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRemediationConfigurationsInput{}
	}

	req := c.newRequest(op, input, &DescribeRemediationConfigurationsOutput{})

	return DescribeRemediationConfigurationsRequest{Request: req, Input: input, Copy: c.DescribeRemediationConfigurationsRequest}
}

// DescribeRemediationConfigurationsRequest is the request type for the
// DescribeRemediationConfigurations API operation.
type DescribeRemediationConfigurationsRequest struct {
	*aws.Request
	Input *DescribeRemediationConfigurationsInput
	Copy  func(*DescribeRemediationConfigurationsInput) DescribeRemediationConfigurationsRequest
}

// Send marshals and sends the DescribeRemediationConfigurations API request.
func (r DescribeRemediationConfigurationsRequest) Send(ctx context.Context) (*DescribeRemediationConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRemediationConfigurationsResponse{
		DescribeRemediationConfigurationsOutput: r.Request.Data.(*DescribeRemediationConfigurationsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRemediationConfigurationsResponse is the response type for the
// DescribeRemediationConfigurations API operation.
type DescribeRemediationConfigurationsResponse struct {
	*DescribeRemediationConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRemediationConfigurations request.
func (r *DescribeRemediationConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
