// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteEvaluationResultsInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule for which you want to delete the evaluation
	// results.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEvaluationResultsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEvaluationResultsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEvaluationResultsInput"}

	if s.ConfigRuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output when you delete the evaluation results for the specified AWS Config
// rule.
type DeleteEvaluationResultsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEvaluationResultsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEvaluationResults = "DeleteEvaluationResults"

// DeleteEvaluationResultsRequest returns a request value for making API operation for
// AWS Config.
//
// Deletes the evaluation results for the specified AWS Config rule. You can
// specify one AWS Config rule per request. After you delete the evaluation
// results, you can call the StartConfigRulesEvaluation API to start evaluating
// your AWS resources against the rule.
//
//    // Example sending a request using DeleteEvaluationResultsRequest.
//    req := client.DeleteEvaluationResultsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults
func (c *Client) DeleteEvaluationResultsRequest(input *DeleteEvaluationResultsInput) DeleteEvaluationResultsRequest {
	op := &aws.Operation{
		Name:       opDeleteEvaluationResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEvaluationResultsInput{}
	}

	req := c.newRequest(op, input, &DeleteEvaluationResultsOutput{})

	return DeleteEvaluationResultsRequest{Request: req, Input: input, Copy: c.DeleteEvaluationResultsRequest}
}

// DeleteEvaluationResultsRequest is the request type for the
// DeleteEvaluationResults API operation.
type DeleteEvaluationResultsRequest struct {
	*aws.Request
	Input *DeleteEvaluationResultsInput
	Copy  func(*DeleteEvaluationResultsInput) DeleteEvaluationResultsRequest
}

// Send marshals and sends the DeleteEvaluationResults API request.
func (r DeleteEvaluationResultsRequest) Send(ctx context.Context) (*DeleteEvaluationResultsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEvaluationResultsResponse{
		DeleteEvaluationResultsOutput: r.Request.Data.(*DeleteEvaluationResultsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEvaluationResultsResponse is the response type for the
// DeleteEvaluationResults API operation.
type DeleteEvaluationResultsResponse struct {
	*DeleteEvaluationResultsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEvaluationResults request.
func (r *DeleteEvaluationResultsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
