// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to verify user attributes.
type VerifyUserAttributeInput struct {
	_ struct{} `type:"structure"`

	// Represents the access token of the request to verify user attributes.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// The attribute name in the request to verify user attributes.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The verification code in the request to verify user attributes.
	//
	// Code is a required field
	Code *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyUserAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyUserAttributeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VerifyUserAttributeInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if s.Code == nil {
		invalidParams.Add(aws.NewErrParamRequired("Code"))
	}
	if s.Code != nil && len(*s.Code) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Code", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A container representing the response from the server from the request to
// verify user attributes.
type VerifyUserAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VerifyUserAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

const opVerifyUserAttribute = "VerifyUserAttribute"

// VerifyUserAttributeRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Verifies the specified user attributes in the user pool.
//
//    // Example sending a request using VerifyUserAttributeRequest.
//    req := client.VerifyUserAttributeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute
func (c *Client) VerifyUserAttributeRequest(input *VerifyUserAttributeInput) VerifyUserAttributeRequest {
	op := &aws.Operation{
		Name:       opVerifyUserAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyUserAttributeInput{}
	}

	req := c.newRequest(op, input, &VerifyUserAttributeOutput{})
	req.Config.Credentials = aws.AnonymousCredentials

	return VerifyUserAttributeRequest{Request: req, Input: input, Copy: c.VerifyUserAttributeRequest}
}

// VerifyUserAttributeRequest is the request type for the
// VerifyUserAttribute API operation.
type VerifyUserAttributeRequest struct {
	*aws.Request
	Input *VerifyUserAttributeInput
	Copy  func(*VerifyUserAttributeInput) VerifyUserAttributeRequest
}

// Send marshals and sends the VerifyUserAttribute API request.
func (r VerifyUserAttributeRequest) Send(ctx context.Context) (*VerifyUserAttributeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &VerifyUserAttributeResponse{
		VerifyUserAttributeOutput: r.Request.Data.(*VerifyUserAttributeOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// VerifyUserAttributeResponse is the response type for the
// VerifyUserAttribute API operation.
type VerifyUserAttributeResponse struct {
	*VerifyUserAttributeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// VerifyUserAttribute request.
func (r *VerifyUserAttributeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
