// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGroupInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group object for the group.
	Group *GroupType `type:"structure"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetGroup = "GetGroup"

// GetGroupRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Gets a group.
//
// Calling this action requires developer credentials.
//
//    // Example sending a request using GetGroupRequest.
//    req := client.GetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup
func (c *Client) GetGroupRequest(input *GetGroupInput) GetGroupRequest {
	op := &aws.Operation{
		Name:       opGetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	req := c.newRequest(op, input, &GetGroupOutput{})

	return GetGroupRequest{Request: req, Input: input, Copy: c.GetGroupRequest}
}

// GetGroupRequest is the request type for the
// GetGroup API operation.
type GetGroupRequest struct {
	*aws.Request
	Input *GetGroupInput
	Copy  func(*GetGroupInput) GetGroupRequest
}

// Send marshals and sends the GetGroup API request.
func (r GetGroupRequest) Send(ctx context.Context) (*GetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGroupResponse{
		GetGroupOutput: r.Request.Data.(*GetGroupOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGroupResponse is the response type for the
// GetGroup API operation.
type GetGroupResponse struct {
	*GetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGroup request.
func (r *GetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
