// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codestarnotificationsiface provides an interface to enable mocking the AWS CodeStar Notifications service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codestarnotificationsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/codestarnotifications"
)

// ClientAPI provides an interface to enable mocking the
// codestarnotifications.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS CodeStar Notifications.
//    func myFunc(svc codestarnotificationsiface.ClientAPI) bool {
//        // Make svc.CreateNotificationRule request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := codestarnotifications.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        codestarnotificationsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateNotificationRule(input *codestarnotifications.CreateNotificationRuleInput) (*codestarnotifications.CreateNotificationRuleOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateNotificationRuleRequest(*codestarnotifications.CreateNotificationRuleInput) codestarnotifications.CreateNotificationRuleRequest

	DeleteNotificationRuleRequest(*codestarnotifications.DeleteNotificationRuleInput) codestarnotifications.DeleteNotificationRuleRequest

	DeleteTargetRequest(*codestarnotifications.DeleteTargetInput) codestarnotifications.DeleteTargetRequest

	DescribeNotificationRuleRequest(*codestarnotifications.DescribeNotificationRuleInput) codestarnotifications.DescribeNotificationRuleRequest

	ListEventTypesRequest(*codestarnotifications.ListEventTypesInput) codestarnotifications.ListEventTypesRequest

	ListNotificationRulesRequest(*codestarnotifications.ListNotificationRulesInput) codestarnotifications.ListNotificationRulesRequest

	ListTagsForResourceRequest(*codestarnotifications.ListTagsForResourceInput) codestarnotifications.ListTagsForResourceRequest

	ListTargetsRequest(*codestarnotifications.ListTargetsInput) codestarnotifications.ListTargetsRequest

	SubscribeRequest(*codestarnotifications.SubscribeInput) codestarnotifications.SubscribeRequest

	TagResourceRequest(*codestarnotifications.TagResourceInput) codestarnotifications.TagResourceRequest

	UnsubscribeRequest(*codestarnotifications.UnsubscribeInput) codestarnotifications.UnsubscribeRequest

	UntagResourceRequest(*codestarnotifications.UntagResourceInput) codestarnotifications.UntagResourceRequest

	UpdateNotificationRuleRequest(*codestarnotifications.UpdateNotificationRuleInput) codestarnotifications.UpdateNotificationRuleRequest
}

var _ ClientAPI = (*codestarnotifications.Client)(nil)
