// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarconnections

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListHostsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `type:"integer"`

	// The token that was returned from the previous ListHosts call, which can be
	// used to return the next set of hosts in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListHostsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHostsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListHostsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListHostsOutput struct {
	_ struct{} `type:"structure"`

	// A list of hosts and the details for each host, such as status, endpoint,
	// and provider type.
	Hosts []Host `type:"list"`

	// A token that can be used in the next ListHosts call. To view all items in
	// the list, continue to call this operation with each subsequent token until
	// no more nextToken values are returned.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListHostsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListHosts = "ListHosts"

// ListHostsRequest returns a request value for making API operation for
// AWS CodeStar connections.
//
// Lists the hosts associated with your account.
//
//    // Example sending a request using ListHostsRequest.
//    req := client.ListHostsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListHosts
func (c *Client) ListHostsRequest(input *ListHostsInput) ListHostsRequest {
	op := &aws.Operation{
		Name:       opListHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHostsInput{}
	}

	req := c.newRequest(op, input, &ListHostsOutput{})

	return ListHostsRequest{Request: req, Input: input, Copy: c.ListHostsRequest}
}

// ListHostsRequest is the request type for the
// ListHosts API operation.
type ListHostsRequest struct {
	*aws.Request
	Input *ListHostsInput
	Copy  func(*ListHostsInput) ListHostsRequest
}

// Send marshals and sends the ListHosts API request.
func (r ListHostsRequest) Send(ctx context.Context) (*ListHostsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListHostsResponse{
		ListHostsOutput: r.Request.Data.(*ListHostsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListHostsRequestPaginator returns a paginator for ListHosts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListHostsRequest(input)
//   p := codestarconnections.NewListHostsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListHostsPaginator(req ListHostsRequest) ListHostsPaginator {
	return ListHostsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListHostsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListHostsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListHostsPaginator struct {
	aws.Pager
}

func (p *ListHostsPaginator) CurrentPage() *ListHostsOutput {
	return p.Pager.CurrentPage().(*ListHostsOutput)
}

// ListHostsResponse is the response type for the
// ListHosts API operation.
type ListHostsResponse struct {
	*ListHostsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListHosts request.
func (r *ListHostsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
