// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarconnections

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateHostInput struct {
	_ struct{} `type:"structure"`

	// The name of the host to be created. The name must be unique in the calling
	// AWS account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The endpoint of the infrastructure to be represented by the host after it
	// is created.
	//
	// ProviderEndpoint is a required field
	ProviderEndpoint *string `min:"1" type:"string" required:"true"`

	// The name of the installed provider to be associated with your connection.
	// The host resource represents the infrastructure where your provider type
	// is installed. The valid provider type is GitHub Enterprise Server.
	//
	// ProviderType is a required field
	ProviderType ProviderType `type:"string" required:"true" enum:"true"`

	// The VPC configuration to be provisioned for the host. A VPC must be configured
	// and the infrastructure to be represented by the host must already be connected
	// to the VPC.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateHostInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHostInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateHostInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.ProviderEndpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProviderEndpoint"))
	}
	if s.ProviderEndpoint != nil && len(*s.ProviderEndpoint) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProviderEndpoint", 1))
	}
	if len(s.ProviderType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ProviderType"))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateHostOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the host to be created.
	HostArn *string `type:"string"`
}

// String returns the string representation
func (s CreateHostOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateHost = "CreateHost"

// CreateHostRequest returns a request value for making API operation for
// AWS CodeStar connections.
//
// Creates a resource that represents the infrastructure where a third-party
// provider is installed. The host is used when you create connections to an
// installed third-party provider type, such as GitHub Enterprise Server. You
// create one host for all connections to that provider.
//
// A host created through the CLI or the SDK is in `PENDING` status by default.
// You can make its status `AVAILABLE` by setting up the host in the console.
//
//    // Example sending a request using CreateHostRequest.
//    req := client.CreateHostRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateHost
func (c *Client) CreateHostRequest(input *CreateHostInput) CreateHostRequest {
	op := &aws.Operation{
		Name:       opCreateHost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHostInput{}
	}

	req := c.newRequest(op, input, &CreateHostOutput{})

	return CreateHostRequest{Request: req, Input: input, Copy: c.CreateHostRequest}
}

// CreateHostRequest is the request type for the
// CreateHost API operation.
type CreateHostRequest struct {
	*aws.Request
	Input *CreateHostInput
	Copy  func(*CreateHostInput) CreateHostRequest
}

// Send marshals and sends the CreateHost API request.
func (r CreateHostRequest) Send(ctx context.Context) (*CreateHostResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateHostResponse{
		CreateHostOutput: r.Request.Data.(*CreateHostOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateHostResponse is the response type for the
// CreateHost API operation.
type CreateHostResponse struct {
	*CreateHostOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateHost request.
func (r *CreateHostResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
