// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateTeamMemberInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS CodeStar project from which you want to remove a team member.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM user or group whom you want to
	// remove from the project.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateTeamMemberInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTeamMemberInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateTeamMemberInput"}

	if s.ProjectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectId", 2))
	}

	if s.UserArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateTeamMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateTeamMemberOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateTeamMember = "DisassociateTeamMember"

// DisassociateTeamMemberRequest returns a request value for making API operation for
// AWS CodeStar.
//
// Removes a user from a project. Removing a user from a project also removes
// the IAM policies from that user that allowed access to the project and its
// resources. Disassociating a team member does not remove that user's profile
// from AWS CodeStar. It does not remove the user from IAM.
//
//    // Example sending a request using DisassociateTeamMemberRequest.
//    req := client.DisassociateTeamMemberRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DisassociateTeamMember
func (c *Client) DisassociateTeamMemberRequest(input *DisassociateTeamMemberInput) DisassociateTeamMemberRequest {
	op := &aws.Operation{
		Name:       opDisassociateTeamMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateTeamMemberInput{}
	}

	req := c.newRequest(op, input, &DisassociateTeamMemberOutput{})

	return DisassociateTeamMemberRequest{Request: req, Input: input, Copy: c.DisassociateTeamMemberRequest}
}

// DisassociateTeamMemberRequest is the request type for the
// DisassociateTeamMember API operation.
type DisassociateTeamMemberRequest struct {
	*aws.Request
	Input *DisassociateTeamMemberInput
	Copy  func(*DisassociateTeamMemberInput) DisassociateTeamMemberRequest
}

// Send marshals and sends the DisassociateTeamMember API request.
func (r DisassociateTeamMemberRequest) Send(ctx context.Context) (*DisassociateTeamMemberResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateTeamMemberResponse{
		DisassociateTeamMemberOutput: r.Request.Data.(*DisassociateTeamMemberOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateTeamMemberResponse is the response type for the
// DisassociateTeamMember API operation.
type DisassociateTeamMemberResponse struct {
	*DisassociateTeamMemberOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateTeamMember request.
func (r *DisassociateTeamMemberResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
