// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProjectInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the project.
	Arn *string `locationName:"arn" type:"string"`

	// A user- or system-generated token that identifies the entity that requested
	// project creation.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The date and time the project was created, in timestamp format.
	CreatedTimeStamp *time.Time `locationName:"createdTimeStamp" type:"timestamp"`

	// The description of the project, if any.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the project.
	Id *string `locationName:"id" min:"2" type:"string"`

	// The display name for the project.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`

	// The ID for the AWS CodeStar project template used to create the project.
	ProjectTemplateId *string `locationName:"projectTemplateId" min:"1" type:"string"`

	// The ID of the primary stack in AWS CloudFormation used to generate resources
	// for the project.
	StackId *string `locationName:"stackId" type:"string"`

	// The project creation or deletion status.
	Status *ProjectStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest returns a request value for making API operation for
// AWS CodeStar.
//
// Describes a project and its resources.
//
//    // Example sending a request using DescribeProjectRequest.
//    req := client.DescribeProjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeProject
func (c *Client) DescribeProjectRequest(input *DescribeProjectInput) DescribeProjectRequest {
	op := &aws.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	req := c.newRequest(op, input, &DescribeProjectOutput{})

	return DescribeProjectRequest{Request: req, Input: input, Copy: c.DescribeProjectRequest}
}

// DescribeProjectRequest is the request type for the
// DescribeProject API operation.
type DescribeProjectRequest struct {
	*aws.Request
	Input *DescribeProjectInput
	Copy  func(*DescribeProjectInput) DescribeProjectRequest
}

// Send marshals and sends the DescribeProject API request.
func (r DescribeProjectRequest) Send(ctx context.Context) (*DescribeProjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProjectResponse{
		DescribeProjectOutput: r.Request.Data.(*DescribeProjectOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProjectResponse is the response type for the
// DescribeProject API operation.
type DescribeProjectResponse struct {
	*DescribeProjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProject request.
func (r *DescribeProjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
