// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a PollForJobs action.
type PollForJobsInput struct {
	_ struct{} `type:"structure"`

	// Represents information about an action type.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int64 `locationName:"maxBatchSize" min:"1" type:"integer"`

	// A map of property names and values. For an action type with no queryable
	// properties, this value must be null or an empty map. For an action type with
	// a queryable property, you must supply that property as a key in the map.
	// Only jobs whose action configuration matches the mapped value are returned.
	QueryParam map[string]string `locationName:"queryParam" type:"map"`
}

// String returns the string representation
func (s PollForJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PollForJobsInput"}

	if s.ActionTypeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActionTypeId"))
	}
	if s.MaxBatchSize != nil && *s.MaxBatchSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxBatchSize", 1))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a PollForJobs action.
type PollForJobsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the jobs to take action on.
	Jobs []Job `locationName:"jobs" type:"list"`
}

// String returns the string representation
func (s PollForJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPollForJobs = "PollForJobs"

// PollForJobsRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Returns information about any jobs for AWS CodePipeline to act on. PollForJobs
// is valid only for action types with "Custom" in the owner field. If the action
// type contains "AWS" or "ThirdParty" in the owner field, the PollForJobs action
// returns an error.
//
// When this API is called, AWS CodePipeline returns temporary credentials for
// the S3 bucket used to store artifacts for the pipeline, if the action requires
// access to that S3 bucket for input or output artifacts. This API also returns
// any secret values defined for the action.
//
//    // Example sending a request using PollForJobsRequest.
//    req := client.PollForJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobs
func (c *Client) PollForJobsRequest(input *PollForJobsInput) PollForJobsRequest {
	op := &aws.Operation{
		Name:       opPollForJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForJobsInput{}
	}

	req := c.newRequest(op, input, &PollForJobsOutput{})

	return PollForJobsRequest{Request: req, Input: input, Copy: c.PollForJobsRequest}
}

// PollForJobsRequest is the request type for the
// PollForJobs API operation.
type PollForJobsRequest struct {
	*aws.Request
	Input *PollForJobsInput
	Copy  func(*PollForJobsInput) PollForJobsRequest
}

// Send marshals and sends the PollForJobs API request.
func (r PollForJobsRequest) Send(ctx context.Context) (*PollForJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PollForJobsResponse{
		PollForJobsOutput: r.Request.Data.(*PollForJobsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PollForJobsResponse is the response type for the
// PollForJobs API operation.
type PollForJobsResponse struct {
	*PollForJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PollForJobs request.
func (r *PollForJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
