// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a GetJobDetails action.
type GetJobDetailsInput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJobDetailsInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a GetJobDetails action.
type GetJobDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the job.
	//
	// If AWSSessionCredentials is used, a long-running job can call GetJobDetails
	// again to obtain new credentials.
	JobDetails *JobDetails `locationName:"jobDetails" type:"structure"`
}

// String returns the string representation
func (s GetJobDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetJobDetails = "GetJobDetails"

// GetJobDetailsRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Returns information about a job. Used for custom actions only.
//
// When this API is called, AWS CodePipeline returns temporary credentials for
// the S3 bucket used to store artifacts for the pipeline, if the action requires
// access to that S3 bucket for input or output artifacts. This API also returns
// any secret values defined for the action.
//
//    // Example sending a request using GetJobDetailsRequest.
//    req := client.GetJobDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetails
func (c *Client) GetJobDetailsRequest(input *GetJobDetailsInput) GetJobDetailsRequest {
	op := &aws.Operation{
		Name:       opGetJobDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobDetailsInput{}
	}

	req := c.newRequest(op, input, &GetJobDetailsOutput{})

	return GetJobDetailsRequest{Request: req, Input: input, Copy: c.GetJobDetailsRequest}
}

// GetJobDetailsRequest is the request type for the
// GetJobDetails API operation.
type GetJobDetailsRequest struct {
	*aws.Request
	Input *GetJobDetailsInput
	Copy  func(*GetJobDetailsInput) GetJobDetailsRequest
}

// Send marshals and sends the GetJobDetails API request.
func (r GetJobDetailsRequest) Send(ctx context.Context) (*GetJobDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJobDetailsResponse{
		GetJobDetailsOutput: r.Request.Data.(*GetJobDetailsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetJobDetailsResponse is the response type for the
// GetJobDetails API operation.
type GetJobDetailsResponse struct {
	*GetJobDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJobDetails request.
func (r *GetJobDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
