// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the GetRecommendationsRequest.
type GetRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The start time of the profile to get analysis data about. You must specify
	// startTime and endTime. This is specified using the ISO 8601 format. For example,
	// 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
	// PM UTC.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The language used to provide analysis. Specify using a string that is one
	// of the following BCP 47 language codes.
	//
	//    * de-DE - German, Germany
	//
	//    * en-GB - English, United Kingdom
	//
	//    * en-US - English, United States
	//
	//    * es-ES - Spanish, Spain
	//
	//    * fr-FR - French, France
	//
	//    * it-IT - Italian, Italy
	//
	//    * ja-JP - Japanese, Japan
	//
	//    * ko-KR - Korean, Republic of Korea
	//
	//    * pt-BR - Portugese, Brazil
	//
	//    * zh-CN - Chinese, China
	//
	//    * zh-TW - Chinese, Taiwan
	Locale *string `location:"querystring" locationName:"locale" type:"string"`

	// The name of the profiling group to get analysis data about.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The end time of the profile to get analysis data about. You must specify
	// startTime and endTime. This is specified using the ISO 8601 format. For example,
	// 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
	// PM UTC.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s GetRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommendationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRecommendationsInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecommendationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.Locale != nil {
		v := *s.Locale

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "locale", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	return nil
}

// The structure representing the GetRecommendationsResponse.
type GetRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of anomalies that the analysis has found for this profile.
	//
	// Anomalies is a required field
	Anomalies []Anomaly `locationName:"anomalies" type:"list" required:"true"`

	// The end time of the profile the analysis data is about. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents
	// 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// ProfileEndTime is a required field
	ProfileEndTime *time.Time `locationName:"profileEndTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The start time of the profile the analysis data is about. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents
	// 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// ProfileStartTime is a required field
	ProfileStartTime *time.Time `locationName:"profileStartTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the profiling group the analysis data is about.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The list of recommendations that the analysis found for this profile.
	//
	// Recommendations is a required field
	Recommendations []Recommendation `locationName:"recommendations" type:"list" required:"true"`
}

// String returns the string representation
func (s GetRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecommendationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Anomalies != nil {
		v := s.Anomalies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "anomalies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProfileEndTime != nil {
		v := *s.ProfileEndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profileEndTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ProfileStartTime != nil {
		v := *s.ProfileStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profileStartTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Recommendations != nil {
		v := s.Recommendations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "recommendations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetRecommendations = "GetRecommendations"

// GetRecommendationsRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Returns a list of Recommendation (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html)
// objects that contain recommendations for a profiling group for a given time
// period. A list of Anomaly (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html)
// objects that contains details about anomalies detected in the profiling group
// for the same time period is also returned.
//
//    // Example sending a request using GetRecommendationsRequest.
//    req := client.GetRecommendationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetRecommendations
func (c *Client) GetRecommendationsRequest(input *GetRecommendationsInput) GetRecommendationsRequest {
	op := &aws.Operation{
		Name:       opGetRecommendations,
		HTTPMethod: "GET",
		HTTPPath:   "/internal/profilingGroups/{profilingGroupName}/recommendations",
	}

	if input == nil {
		input = &GetRecommendationsInput{}
	}

	req := c.newRequest(op, input, &GetRecommendationsOutput{})

	return GetRecommendationsRequest{Request: req, Input: input, Copy: c.GetRecommendationsRequest}
}

// GetRecommendationsRequest is the request type for the
// GetRecommendations API operation.
type GetRecommendationsRequest struct {
	*aws.Request
	Input *GetRecommendationsInput
	Copy  func(*GetRecommendationsInput) GetRecommendationsRequest
}

// Send marshals and sends the GetRecommendations API request.
func (r GetRecommendationsRequest) Send(ctx context.Context) (*GetRecommendationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRecommendationsResponse{
		GetRecommendationsOutput: r.Request.Data.(*GetRecommendationsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRecommendationsResponse is the response type for the
// GetRecommendations API operation.
type GetRecommendationsResponse struct {
	*GetRecommendationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRecommendations request.
func (r *GetRecommendationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
