// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteResourcesByExternalIdInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of an external resource (for example, a CloudFormation stack
	// ID) that is linked to one or more CodeDeploy resources.
	ExternalId *string `locationName:"externalId" type:"string"`
}

// String returns the string representation
func (s DeleteResourcesByExternalIdInput) String() string {
	return awsutil.Prettify(s)
}

type DeleteResourcesByExternalIdOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourcesByExternalIdOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteResourcesByExternalId = "DeleteResourcesByExternalId"

// DeleteResourcesByExternalIdRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Deletes resources linked to an external ID.
//
//    // Example sending a request using DeleteResourcesByExternalIdRequest.
//    req := client.DeleteResourcesByExternalIdRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId
func (c *Client) DeleteResourcesByExternalIdRequest(input *DeleteResourcesByExternalIdInput) DeleteResourcesByExternalIdRequest {
	op := &aws.Operation{
		Name:       opDeleteResourcesByExternalId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcesByExternalIdInput{}
	}

	req := c.newRequest(op, input, &DeleteResourcesByExternalIdOutput{})

	return DeleteResourcesByExternalIdRequest{Request: req, Input: input, Copy: c.DeleteResourcesByExternalIdRequest}
}

// DeleteResourcesByExternalIdRequest is the request type for the
// DeleteResourcesByExternalId API operation.
type DeleteResourcesByExternalIdRequest struct {
	*aws.Request
	Input *DeleteResourcesByExternalIdInput
	Copy  func(*DeleteResourcesByExternalIdInput) DeleteResourcesByExternalIdRequest
}

// Send marshals and sends the DeleteResourcesByExternalId API request.
func (r DeleteResourcesByExternalIdRequest) Send(ctx context.Context) (*DeleteResourcesByExternalIdResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteResourcesByExternalIdResponse{
		DeleteResourcesByExternalIdOutput: r.Request.Data.(*DeleteResourcesByExternalIdOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteResourcesByExternalIdResponse is the response type for the
// DeleteResourcesByExternalId API operation.
type DeleteResourcesByExternalIdResponse struct {
	*DeleteResourcesByExternalIdOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteResourcesByExternalId request.
func (r *DeleteResourcesByExternalIdResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
