// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateApprovalRuleTemplateNameInput struct {
	_ struct{} `type:"structure"`

	// The new name you want to apply to the approval rule template.
	//
	// NewApprovalRuleTemplateName is a required field
	NewApprovalRuleTemplateName *string `locationName:"newApprovalRuleTemplateName" min:"1" type:"string" required:"true"`

	// The current name of the approval rule template.
	//
	// OldApprovalRuleTemplateName is a required field
	OldApprovalRuleTemplateName *string `locationName:"oldApprovalRuleTemplateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApprovalRuleTemplateNameInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApprovalRuleTemplateNameInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateApprovalRuleTemplateNameInput"}

	if s.NewApprovalRuleTemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewApprovalRuleTemplateName"))
	}
	if s.NewApprovalRuleTemplateName != nil && len(*s.NewApprovalRuleTemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NewApprovalRuleTemplateName", 1))
	}

	if s.OldApprovalRuleTemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("OldApprovalRuleTemplateName"))
	}
	if s.OldApprovalRuleTemplateName != nil && len(*s.OldApprovalRuleTemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OldApprovalRuleTemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateApprovalRuleTemplateNameOutput struct {
	_ struct{} `type:"structure"`

	// The structure and content of the updated approval rule template.
	//
	// ApprovalRuleTemplate is a required field
	ApprovalRuleTemplate *ApprovalRuleTemplate `locationName:"approvalRuleTemplate" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApprovalRuleTemplateNameOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateApprovalRuleTemplateName = "UpdateApprovalRuleTemplateName"

// UpdateApprovalRuleTemplateNameRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Updates the name of a specified approval rule template.
//
//    // Example sending a request using UpdateApprovalRuleTemplateNameRequest.
//    req := client.UpdateApprovalRuleTemplateNameRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateName
func (c *Client) UpdateApprovalRuleTemplateNameRequest(input *UpdateApprovalRuleTemplateNameInput) UpdateApprovalRuleTemplateNameRequest {
	op := &aws.Operation{
		Name:       opUpdateApprovalRuleTemplateName,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApprovalRuleTemplateNameInput{}
	}

	req := c.newRequest(op, input, &UpdateApprovalRuleTemplateNameOutput{})

	return UpdateApprovalRuleTemplateNameRequest{Request: req, Input: input, Copy: c.UpdateApprovalRuleTemplateNameRequest}
}

// UpdateApprovalRuleTemplateNameRequest is the request type for the
// UpdateApprovalRuleTemplateName API operation.
type UpdateApprovalRuleTemplateNameRequest struct {
	*aws.Request
	Input *UpdateApprovalRuleTemplateNameInput
	Copy  func(*UpdateApprovalRuleTemplateNameInput) UpdateApprovalRuleTemplateNameRequest
}

// Send marshals and sends the UpdateApprovalRuleTemplateName API request.
func (r UpdateApprovalRuleTemplateNameRequest) Send(ctx context.Context) (*UpdateApprovalRuleTemplateNameResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateApprovalRuleTemplateNameResponse{
		UpdateApprovalRuleTemplateNameOutput: r.Request.Data.(*UpdateApprovalRuleTemplateNameOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateApprovalRuleTemplateNameResponse is the response type for the
// UpdateApprovalRuleTemplateName API operation.
type UpdateApprovalRuleTemplateNameResponse struct {
	*UpdateApprovalRuleTemplateNameOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateApprovalRuleTemplateName request.
func (r *UpdateApprovalRuleTemplateNameResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
