// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about a build.
type Build struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Information about the output artifacts for the build.
	Artifacts *BuildArtifacts `locationName:"artifacts" type:"structure"`

	// Whether the build is complete. True if complete; otherwise, false.
	BuildComplete *bool `locationName:"buildComplete" type:"boolean"`

	// The number of the build. For each project, the buildNumber of its first build
	// is 1. The buildNumber of each subsequent build is incremented by 1. If a
	// build is deleted, the buildNumber of other builds does not change.
	BuildNumber *int64 `locationName:"buildNumber" type:"long"`

	// The current status of the build. Valid values include:
	//
	//    * FAILED: The build failed.
	//
	//    * FAULT: The build faulted.
	//
	//    * IN_PROGRESS: The build is still in progress.
	//
	//    * STOPPED: The build stopped.
	//
	//    * SUCCEEDED: The build succeeded.
	//
	//    * TIMED_OUT: The build timed out.
	BuildStatus StatusType `locationName:"buildStatus" type:"string" enum:"true"`

	// Information about the cache for the build.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// The current build phase.
	CurrentPhase *string `locationName:"currentPhase" type:"string"`

	// Contains information about the debug session for this build.
	DebugSession *DebugSession `locationName:"debugSession" type:"structure"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// You can use a cross-account KMS key to encrypt the build output artifacts
	// if your service role has permission to that key.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK's alias (using the format alias/alias-name ).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// When the build process ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Information about the build environment for this build.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// A list of exported environment variables for this build.
	ExportedEnvironmentVariables []ExportedEnvironmentVariable `locationName:"exportedEnvironmentVariables" type:"list"`

	// An array of ProjectFileSystemLocation objects for a CodeBuild build project.
	// A ProjectFileSystemLocation object specifies the identifier, location, mountOptions,
	// mountPoint, and type of a file system created using Amazon Elastic File System.
	FileSystemLocations []ProjectFileSystemLocation `locationName:"fileSystemLocations" type:"list"`

	// The unique ID for the build.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The entity that started the build. Valid values include:
	//
	//    * If AWS CodePipeline started the build, the pipeline's name (for example,
	//    codepipeline/my-demo-pipeline).
	//
	//    * If an AWS Identity and Access Management (IAM) user started the build,
	//    the user's name (for example, MyUserName).
	//
	//    * If the Jenkins plugin for AWS CodeBuild started the build, the string
	//    CodeBuild-Jenkins-Plugin.
	Initiator *string `locationName:"initiator" type:"string"`

	// Information about the build's logs in Amazon CloudWatch Logs.
	Logs *LogsLocation `locationName:"logs" type:"structure"`

	// Describes a network interface.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`

	// Information about all previous build phases that are complete and information
	// about any current build phase that is not yet complete.
	Phases []BuildPhase `locationName:"phases" type:"list"`

	// The name of the AWS CodeBuild project.
	ProjectName *string `locationName:"projectName" min:"1" type:"string"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" type:"integer"`

	// An array of the ARNs associated with this build's reports.
	ReportArns []string `locationName:"reportArns" type:"list"`

	// An identifier for the version of this build's source code.
	//
	//    * For AWS CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit
	//    ID.
	//
	//    * For AWS CodePipeline, the source revision provided by AWS CodePipeline.
	//
	//    * For Amazon Simple Storage Service (Amazon S3), this does not apply.
	ResolvedSourceVersion *string `locationName:"resolvedSourceVersion" min:"1" type:"string"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifacts []BuildArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSourceVersion objects. Each ProjectSourceVersion must
	// be one of:
	//
	//    * For AWS CodeCommit: the commit ID, branch, or Git tag to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example, pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	SecondarySourceVersions []ProjectSourceVersion `locationName:"secondarySourceVersions" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []ProjectSource `locationName:"secondarySources" type:"list"`

	// The name of a service role used for this build.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the source code to be built.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// Any version identifier for the version of the source code to be built. If
	// sourceVersion is specified at the project level, then this sourceVersion
	// (at the build level) takes precedence.
	//
	// For more information, see Source Version Sample with CodeBuild (https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
	// in the AWS CodeBuild User Guide.
	SourceVersion *string `locationName:"sourceVersion" min:"1" type:"string"`

	// When the build process started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// How long, in minutes, for AWS CodeBuild to wait before timing out this build
	// if it does not get marked as completed.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" type:"integer"`

	// If your AWS CodeBuild project accesses resources in an Amazon VPC, you provide
	// this parameter that identifies the VPC ID and the list of security group
	// IDs and subnet IDs. The security groups and subnets must belong to the same
	// VPC. You must provide at least one security group and one subnet ID.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// Information about build output artifacts.
type BuildArtifacts struct {
	_ struct{} `type:"structure"`

	// An identifier for this artifact definition.
	ArtifactIdentifier *string `locationName:"artifactIdentifier" type:"string"`

	// Information that tells you if encryption for build artifacts is disabled.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// Information about the location of the build artifacts.
	Location *string `locationName:"location" type:"string"`

	// The MD5 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Md5sum *string `locationName:"md5sum" type:"string"`

	// If this flag is set, a name specified in the buildspec file overrides the
	// artifact name. The name specified in a buildspec file is calculated at build
	// time and uses the Shell Command Language. For example, you can append a date
	// and time to your artifact name so that it is always unique.
	OverrideArtifactName *bool `locationName:"overrideArtifactName" type:"boolean"`

	// The SHA-256 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Sha256sum *string `locationName:"sha256sum" type:"string"`
}

// String returns the string representation
func (s BuildArtifacts) String() string {
	return awsutil.Prettify(s)
}

// Information about a build that could not be successfully deleted.
type BuildNotDeleted struct {
	_ struct{} `type:"structure"`

	// The ID of the build that could not be successfully deleted.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Additional information about the build that could not be successfully deleted.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s BuildNotDeleted) String() string {
	return awsutil.Prettify(s)
}

// Information about a stage for a build.
type BuildPhase struct {
	_ struct{} `type:"structure"`

	// Additional information about a build phase, especially to help troubleshoot
	// a failed build.
	Contexts []PhaseContext `locationName:"contexts" type:"list"`

	// How long, in seconds, between the starting and ending times of the build's
	// phase.
	DurationInSeconds *int64 `locationName:"durationInSeconds" type:"long"`

	// When the build phase ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The current status of the build phase. Valid values include:
	//
	//    * FAILED: The build phase failed.
	//
	//    * FAULT: The build phase faulted.
	//
	//    * IN_PROGRESS: The build phase is still in progress.
	//
	//    * QUEUED: The build has been submitted and is queued behind other submitted
	//    builds.
	//
	//    * STOPPED: The build phase stopped.
	//
	//    * SUCCEEDED: The build phase succeeded.
	//
	//    * TIMED_OUT: The build phase timed out.
	PhaseStatus StatusType `locationName:"phaseStatus" type:"string" enum:"true"`

	// The name of the build phase. Valid values include:
	//
	//    * BUILD: Core build activities typically occur in this build phase.
	//
	//    * COMPLETED: The build has been completed.
	//
	//    * DOWNLOAD_SOURCE: Source code is being downloaded in this build phase.
	//
	//    * FINALIZING: The build process is completing in this build phase.
	//
	//    * INSTALL: Installation activities typically occur in this build phase.
	//
	//    * POST_BUILD: Post-build activities typically occur in this build phase.
	//
	//    * PRE_BUILD: Pre-build activities typically occur in this build phase.
	//
	//    * PROVISIONING: The build environment is being set up.
	//
	//    * QUEUED: The build has been submitted and is queued behind other submitted
	//    builds.
	//
	//    * SUBMITTED: The build has been submitted.
	//
	//    * UPLOAD_ARTIFACTS: Build output artifacts are being uploaded to the output
	//    location.
	PhaseType BuildPhaseType `locationName:"phaseType" type:"string" enum:"true"`

	// When the build phase started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s BuildPhase) String() string {
	return awsutil.Prettify(s)
}

// Contains information that defines how the AWS CodeBuild build project reports
// the build status to the source provider.
type BuildStatusConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the context of the build status CodeBuild sends to the source provider.
	// The usage of this parameter depends on the source provider.
	//
	// Bitbucket
	//
	// This parameter is used for the name parameter in the Bitbucket commit status.
	// For more information, see build (https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build)
	// in the Bitbucket API documentation.
	//
	// GitHub/GitHub Enterprise Server
	//
	// This parameter is used for the context parameter in the GitHub commit status.
	// For more information, see Create a commit status (https://developer.github.com/v3/repos/statuses/#create-a-commit-status)
	// in the GitHub developer guide.
	Context *string `locationName:"context" type:"string"`

	// Specifies the target url of the build status CodeBuild sends to the source
	// provider. The usage of this parameter depends on the source provider.
	//
	// Bitbucket
	//
	// This parameter is used for the url parameter in the Bitbucket commit status.
	// For more information, see build (https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build)
	// in the Bitbucket API documentation.
	//
	// GitHub/GitHub Enterprise Server
	//
	// This parameter is used for the target_url parameter in the GitHub commit
	// status. For more information, see Create a commit status (https://developer.github.com/v3/repos/statuses/#create-a-commit-status)
	// in the GitHub developer guide.
	TargetUrl *string `locationName:"targetUrl" type:"string"`
}

// String returns the string representation
func (s BuildStatusConfig) String() string {
	return awsutil.Prettify(s)
}

// Information about Amazon CloudWatch Logs for a build project.
type CloudWatchLogsConfig struct {
	_ struct{} `type:"structure"`

	// The group name of the logs in Amazon CloudWatch Logs. For more information,
	// see Working with Log Groups and Log Streams (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
	GroupName *string `locationName:"groupName" type:"string"`

	// The current status of the logs in Amazon CloudWatch Logs for a build project.
	// Valid values are:
	//
	//    * ENABLED: Amazon CloudWatch Logs are enabled for this build project.
	//
	//    * DISABLED: Amazon CloudWatch Logs are not enabled for this build project.
	//
	// Status is a required field
	Status LogsConfigStatusType `locationName:"status" type:"string" required:"true" enum:"true"`

	// The prefix of the stream name of the Amazon CloudWatch Logs. For more information,
	// see Working with Log Groups and Log Streams (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s CloudWatchLogsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchLogsConfig"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about the debug session for a build. For more information,
// see Viewing a running build in Session Manager (https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html).
type DebugSession struct {
	_ struct{} `type:"structure"`

	// Specifies if session debugging is enabled for this build.
	SessionEnabled *bool `locationName:"sessionEnabled" type:"boolean"`

	// Contains the identifier of the Session Manager session used for the build.
	// To work with the paused build, you open this session to examine, control,
	// and resume the build.
	SessionTarget *string `locationName:"sessionTarget" min:"1" type:"string"`
}

// String returns the string representation
func (s DebugSession) String() string {
	return awsutil.Prettify(s)
}

// Information about a Docker image that is managed by AWS CodeBuild.
type EnvironmentImage struct {
	_ struct{} `type:"structure"`

	// The description of the Docker image.
	Description *string `locationName:"description" type:"string"`

	// The name of the Docker image.
	Name *string `locationName:"name" type:"string"`

	// A list of environment image versions.
	Versions []string `locationName:"versions" type:"list"`
}

// String returns the string representation
func (s EnvironmentImage) String() string {
	return awsutil.Prettify(s)
}

// A set of Docker images that are related by programming language and are managed
// by AWS CodeBuild.
type EnvironmentLanguage struct {
	_ struct{} `type:"structure"`

	// The list of Docker images that are related by the specified programming language.
	Images []EnvironmentImage `locationName:"images" type:"list"`

	// The programming language for the Docker images.
	Language LanguageType `locationName:"language" type:"string" enum:"true"`
}

// String returns the string representation
func (s EnvironmentLanguage) String() string {
	return awsutil.Prettify(s)
}

// A set of Docker images that are related by platform and are managed by AWS
// CodeBuild.
type EnvironmentPlatform struct {
	_ struct{} `type:"structure"`

	// The list of programming languages that are available for the specified platform.
	Languages []EnvironmentLanguage `locationName:"languages" type:"list"`

	// The platform's name.
	Platform PlatformType `locationName:"platform" type:"string" enum:"true"`
}

// String returns the string representation
func (s EnvironmentPlatform) String() string {
	return awsutil.Prettify(s)
}

// Information about an environment variable for a build project or a build.
type EnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name or key of the environment variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of environment variable. Valid values include:
	//
	//    * PARAMETER_STORE: An environment variable stored in Amazon EC2 Systems
	//    Manager Parameter Store. To learn how to specify a parameter store environment
	//    variable, see parameter store reference-key in the buildspec file (https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#parameter-store-build-spec).
	//
	//    * PLAINTEXT: An environment variable in plain text format. This is the
	//    default value.
	//
	//    * SECRETS_MANAGER: An environment variable stored in AWS Secrets Manager.
	//    To learn how to specify a secrets manager environment variable, see secrets
	//    manager reference-key in the buildspec file (https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#secrets-manager-build-spec).
	Type EnvironmentVariableType `locationName:"type" type:"string" enum:"true"`

	// The value of the environment variable.
	//
	// We strongly discourage the use of PLAINTEXT environment variables to store
	// sensitive values, especially AWS secret key IDs and secret access keys. PLAINTEXT
	// environment variables can be displayed in plain text using the AWS CodeBuild
	// console and the AWS Command Line Interface (AWS CLI). For sensitive values,
	// we recommend you use an environment variable of type PARAMETER_STORE or SECRETS_MANAGER.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s EnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentVariable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnvironmentVariable"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about an exported environment variable.
type ExportedEnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name of this exported environment variable.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The value assigned to this exported environment variable.
	//
	// During a build, the value of a variable is available starting with the install
	// phase. It can be updated between the start of the install phase and the end
	// of the post_build phase. After the post_build phase ends, the value of exported
	// variables cannot change.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ExportedEnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// Information about the Git submodules configuration for an AWS CodeBuild build
// project.
type GitSubmodulesConfig struct {
	_ struct{} `type:"structure"`

	// Set to true to fetch Git submodules for your AWS CodeBuild build project.
	//
	// FetchSubmodules is a required field
	FetchSubmodules *bool `locationName:"fetchSubmodules" type:"boolean" required:"true"`
}

// String returns the string representation
func (s GitSubmodulesConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitSubmodulesConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GitSubmodulesConfig"}

	if s.FetchSubmodules == nil {
		invalidParams.Add(aws.NewErrParamRequired("FetchSubmodules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about logs for a build project. These can be logs in Amazon CloudWatch
// Logs, built in a specified S3 bucket, or both.
type LogsConfig struct {
	_ struct{} `type:"structure"`

	// Information about Amazon CloudWatch Logs for a build project. Amazon CloudWatch
	// Logs are enabled by default.
	CloudWatchLogs *CloudWatchLogsConfig `locationName:"cloudWatchLogs" type:"structure"`

	// Information about logs built to an S3 bucket for a build project. S3 logs
	// are not enabled by default.
	S3Logs *S3LogsConfig `locationName:"s3Logs" type:"structure"`
}

// String returns the string representation
func (s LogsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogsConfig"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Logs != nil {
		if err := s.S3Logs.Validate(); err != nil {
			invalidParams.AddNested("S3Logs", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about build logs in Amazon CloudWatch Logs.
type LogsLocation struct {
	_ struct{} `type:"structure"`

	// Information about Amazon CloudWatch Logs for a build project.
	CloudWatchLogs *CloudWatchLogsConfig `locationName:"cloudWatchLogs" type:"structure"`

	// The ARN of Amazon CloudWatch Logs for a build project. Its format is arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}.
	// For more information, see Resources Defined by Amazon CloudWatch Logs (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies).
	CloudWatchLogsArn *string `locationName:"cloudWatchLogsArn" type:"string"`

	// The URL to an individual build log in Amazon CloudWatch Logs.
	DeepLink *string `locationName:"deepLink" type:"string"`

	// The name of the Amazon CloudWatch Logs group for the build logs.
	GroupName *string `locationName:"groupName" type:"string"`

	// The URL to a build log in an S3 bucket.
	S3DeepLink *string `locationName:"s3DeepLink" type:"string"`

	// Information about S3 logs for a build project.
	S3Logs *S3LogsConfig `locationName:"s3Logs" type:"structure"`

	// The ARN of S3 logs for a build project. Its format is arn:${Partition}:s3:::${BucketName}/${ObjectName}.
	// For more information, see Resources Defined by Amazon S3 (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies).
	S3LogsArn *string `locationName:"s3LogsArn" type:"string"`

	// The name of the Amazon CloudWatch Logs stream for the build logs.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s LogsLocation) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" min:"1" type:"string"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// Additional information about a build phase that has an error. You can use
// this information for troubleshooting.
type PhaseContext struct {
	_ struct{} `type:"structure"`

	// An explanation of the build phase's context. This might include a command
	// ID and an exit code.
	Message *string `locationName:"message" type:"string"`

	// The status code for the context of the build phase.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s PhaseContext) String() string {
	return awsutil.Prettify(s)
}

// Information about a build project.
type Project struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build project.
	Arn *string `locationName:"arn" type:"string"`

	// Information about the build output artifacts for the build project.
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure"`

	// Information about the build badge for the build project.
	Badge *ProjectBadge `locationName:"badge" type:"structure"`

	// Information about the cache for the build project.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// When the build project was created, expressed in Unix time format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// A description that makes the build project easy to identify.
	Description *string `locationName:"description" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// You can use a cross-account KMS key to encrypt the build output artifacts
	// if your service role has permission to that key.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK's alias (using the format alias/alias-name ).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information about the build environment for this build project.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// An array of ProjectFileSystemLocation objects for a CodeBuild build project.
	// A ProjectFileSystemLocation object specifies the identifier, location, mountOptions,
	// mountPoint, and type of a file system created using Amazon Elastic File System.
	FileSystemLocations []ProjectFileSystemLocation `locationName:"fileSystemLocations" type:"list"`

	// When the build project's settings were last modified, expressed in Unix time
	// format.
	LastModified *time.Time `locationName:"lastModified" type:"timestamp"`

	// Information about logs for the build project. A project can create logs in
	// Amazon CloudWatch Logs, an S3 bucket, or both.
	LogsConfig *LogsConfig `locationName:"logsConfig" type:"structure"`

	// The name of the build project.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" min:"5" type:"integer"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifacts []ProjectArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSourceVersion objects. If secondarySourceVersions is specified
	// at the build level, then they take over these secondarySourceVersions (at
	// the project level).
	SecondarySourceVersions []ProjectSourceVersion `locationName:"secondarySourceVersions" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []ProjectSource `locationName:"secondarySources" type:"list"`

	// The ARN of the AWS Identity and Access Management (IAM) role that enables
	// AWS CodeBuild to interact with dependent AWS services on behalf of the AWS
	// account.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the build input source code for this build project.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// A version of the build input to be built for this project. If not specified,
	// the latest version is used. If specified, it must be one of:
	//
	//    * For AWS CodeCommit: the commit ID, branch, or Git tag to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	//
	// If sourceVersion is specified at the build level, then that version takes
	// precedence over this sourceVersion (at the project level).
	//
	// For more information, see Source Version Sample with CodeBuild (https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
	// in the AWS CodeBuild User Guide.
	SourceVersion *string `locationName:"sourceVersion" type:"string"`

	// A list of tag key and value pairs associated with this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []Tag `locationName:"tags" type:"list"`

	// How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait
	// before timing out any related build that did not get marked as completed.
	// The default is 60 minutes.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`

	// Information about the VPC configuration that AWS CodeBuild accesses.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`

	// Information about a webhook that connects repository events to a build project
	// in AWS CodeBuild.
	Webhook *Webhook `locationName:"webhook" type:"structure"`
}

// String returns the string representation
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// Information about the build output artifacts for the build project.
type ProjectArtifacts struct {
	_ struct{} `type:"structure"`

	// An identifier for this artifact definition.
	ArtifactIdentifier *string `locationName:"artifactIdentifier" type:"string"`

	// Set to true if you do not want your output artifacts encrypted. This option
	// is valid only if your artifacts type is Amazon Simple Storage Service (Amazon
	// S3). If this is set with another artifacts type, an invalidInputException
	// is thrown.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// Information about the build output artifact location:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    locations instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the name of the output bucket.
	Location *string `locationName:"location" type:"string"`

	// Along with path and namespaceType, the pattern that AWS CodeBuild uses to
	// name and store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the name of the output artifact object.
	//    If you set the name to be a forward slash ("/"), the artifact is stored
	//    in the root of the output bucket.
	//
	// For example:
	//
	//    * If path is set to MyArtifacts, namespaceType is set to BUILD_ID, and
	//    name is set to MyArtifact.zip, then the output artifact is stored in MyArtifacts/build-ID/MyArtifact.zip.
	//
	//    * If path is empty, namespaceType is set to NONE, and name is set to "/",
	//    the output artifact is stored in the root of the output bucket.
	//
	//    * If path is set to MyArtifacts, namespaceType is set to BUILD_ID, and
	//    name is set to "/", the output artifact is stored in MyArtifacts/build-ID .
	Name *string `locationName:"name" type:"string"`

	// Along with path and name, the pattern that AWS CodeBuild uses to determine
	// the name and location to store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, valid values include: BUILD_ID: Include the build
	//    ID in the location of the build output artifact. NONE: Do not include
	//    the build ID. This is the default if namespaceType is not specified.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to BUILD_ID,
	// and name is set to MyArtifact.zip, the output artifact is stored in MyArtifacts/build-ID/MyArtifact.zip.
	NamespaceType ArtifactNamespace `locationName:"namespaceType" type:"string" enum:"true"`

	// If this flag is set, a name specified in the buildspec file overrides the
	// artifact name. The name specified in a buildspec file is calculated at build
	// time and uses the Shell Command Language. For example, you can append a date
	// and time to your artifact name so that it is always unique.
	OverrideArtifactName *bool `locationName:"overrideArtifactName" type:"boolean"`

	// The type of build output artifact to create:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    artifacts instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, valid values include: NONE: AWS CodeBuild creates
	//    in the output bucket a folder that contains the build output. This is
	//    the default if packaging is not specified. ZIP: AWS CodeBuild creates
	//    in the output bucket a ZIP file that contains the build output.
	Packaging ArtifactPackaging `locationName:"packaging" type:"string" enum:"true"`

	// Along with namespaceType and name, the pattern that AWS CodeBuild uses to
	// name and store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the path to the output artifact. If path
	//    is not specified, path is not used.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to NONE,
	// and name is set to MyArtifact.zip, the output artifact is stored in the output
	// bucket at MyArtifacts/MyArtifact.zip.
	Path *string `locationName:"path" type:"string"`

	// The type of build output artifact. Valid values include:
	//
	//    * CODEPIPELINE: The build project has build output generated through AWS
	//    CodePipeline. The CODEPIPELINE type is not supported for secondaryArtifacts.
	//
	//    * NO_ARTIFACTS: The build project does not produce any build output.
	//
	//    * S3: The build project stores build output in Amazon Simple Storage Service
	//    (Amazon S3).
	//
	// Type is a required field
	Type ArtifactsType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectArtifacts) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectArtifacts) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectArtifacts"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the build badge for the build project.
type ProjectBadge struct {
	_ struct{} `type:"structure"`

	// Set this to true to generate a publicly accessible URL for your project's
	// build badge.
	BadgeEnabled *bool `locationName:"badgeEnabled" type:"boolean"`

	// The publicly-accessible URL through which you can access the build badge
	// for your project.
	//
	// The publicly accessible URL through which you can access the build badge
	// for your project.
	BadgeRequestUrl *string `locationName:"badgeRequestUrl" type:"string"`
}

// String returns the string representation
func (s ProjectBadge) String() string {
	return awsutil.Prettify(s)
}

// Information about the cache for the build project.
type ProjectCache struct {
	_ struct{} `type:"structure"`

	// Information about the cache location:
	//
	//    * NO_CACHE or LOCAL: This value is ignored.
	//
	//    * S3: This is the S3 bucket name/prefix.
	Location *string `locationName:"location" type:"string"`

	// If you use a LOCAL cache, the local cache mode. You can use one or more local
	// cache modes at the same time.
	//
	//    * LOCAL_SOURCE_CACHE mode caches Git metadata for primary and secondary
	//    sources. After the cache is created, subsequent builds pull only the change
	//    between commits. This mode is a good choice for projects with a clean
	//    working directory and a source that is a large Git repository. If you
	//    choose this option and your project does not use a Git repository (GitHub,
	//    GitHub Enterprise, or Bitbucket), the option is ignored.
	//
	//    * LOCAL_DOCKER_LAYER_CACHE mode caches existing Docker layers. This mode
	//    is a good choice for projects that build or pull large Docker images.
	//    It can prevent the performance issues caused by pulling large Docker images
	//    down from the network. You can use a Docker layer cache in the Linux environment
	//    only. The privileged flag must be set so that your project has the required
	//    Docker permissions. You should consider the security implications before
	//    you use a Docker layer cache.
	//
	//    * LOCAL_CUSTOM_CACHE mode caches directories you specify in the buildspec
	//    file. This mode is a good choice if your build scenario is not suited
	//    to one of the other three local cache modes. If you use a custom cache:
	//    Only directories can be specified for caching. You cannot specify individual
	//    files. Symlinks are used to reference cached directories. Cached directories
	//    are linked to your build before it downloads its project sources. Cached
	//    items are overridden if a source item has the same name. Directories are
	//    specified using cache paths in the buildspec file.
	Modes []CacheMode `locationName:"modes" type:"list"`

	// The type of cache used by the build project. Valid values include:
	//
	//    * NO_CACHE: The build project does not use any cache.
	//
	//    * S3: The build project reads and writes from and to S3.
	//
	//    * LOCAL: The build project stores a cache locally on a build host that
	//    is only available to that build host.
	//
	// Type is a required field
	Type CacheType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectCache) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectCache) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectCache"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the build environment of the build project.
type ProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `locationName:"certificate" type:"string"`

	// Information about the compute resources the build project uses. Available
	// values include:
	//
	//    * BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_LARGE: Use up to 16 GB memory and 8 vCPUs for builds,
	//    depending on your environment type.
	//
	//    * BUILD_GENERAL1_2XLARGE: Use up to 145 GB memory, 72 vCPUs, and 824 GB
	//    of SSD storage for builds. This compute type supports Docker images up
	//    to 100 GB uncompressed.
	//
	// If you use BUILD_GENERAL1_LARGE:
	//
	//    * For environment type LINUX_CONTAINER, you can use up to 15 GB memory
	//    and 8 vCPUs for builds.
	//
	//    * For environment type LINUX_GPU_CONTAINER, you can use up to 255 GB memory,
	//    32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
	//
	//    * For environment type ARM_CONTAINER, you can use up to 16 GB memory and
	//    8 vCPUs on ARM-based processors for builds.
	//
	// For more information, see Build Environment Compute Types (https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html)
	// in the AWS CodeBuild User Guide.
	//
	// ComputeType is a required field
	ComputeType ComputeType `locationName:"computeType" type:"string" required:"true" enum:"true"`

	// A set of environment variables to make available to builds for this build
	// project.
	EnvironmentVariables []EnvironmentVariable `locationName:"environmentVariables" type:"list"`

	// The image tag or image digest that identifies the Docker image to use for
	// this build project. Use the following formats:
	//
	//    * For an image tag: registry/repository:tag. For example, to specify an
	//    image with the tag "latest," use registry/repository:latest.
	//
	//    * For an image digest: registry/repository@digest. For example, to specify
	//    an image with the digest "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf,"
	//    use registry/repository@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf.
	//
	// Image is a required field
	Image *string `locationName:"image" min:"1" type:"string" required:"true"`

	// The type of credentials AWS CodeBuild uses to pull images in your build.
	// There are two valid values:
	//
	//    * CODEBUILD specifies that AWS CodeBuild uses its own credentials. This
	//    requires that you modify your ECR repository policy to trust AWS CodeBuild's
	//    service principal.
	//
	//    * SERVICE_ROLE specifies that AWS CodeBuild uses your build project's
	//    service role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType ImagePullCredentialsType `locationName:"imagePullCredentialsType" type:"string" enum:"true"`

	// Enables running the Docker daemon inside a Docker container. Set to true
	// only if the build project is used to build Docker images. Otherwise, a build
	// that attempts to interact with the Docker daemon fails. The default setting
	// is false.
	//
	// You can initialize the Docker daemon during the install phase of your build
	// by adding one of the following sets of commands to the install phase of your
	// buildspec file:
	//
	// If the operating system's base image is Ubuntu Linux:
	//
	// - nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375
	// --storage-driver=overlay&
	//
	// - timeout 15 sh -c "until docker info; do echo .; sleep 1; done"
	//
	// If the operating system's base image is Alpine Linux and the previous command
	// does not work, add the -t argument to timeout:
	//
	// - nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375
	// --storage-driver=overlay&
	//
	// - timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"
	PrivilegedMode *bool `locationName:"privilegedMode" type:"boolean"`

	// The credentials for access to a private registry.
	RegistryCredential *RegistryCredential `locationName:"registryCredential" type:"structure"`

	// The type of build environment to use for related builds.
	//
	//    * The environment type ARM_CONTAINER is available only in regions US East
	//    (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific
	//    (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and EU (Frankfurt).
	//
	//    * The environment type LINUX_CONTAINER with compute type build.general1.2xlarge
	//    is available only in regions US East (N. Virginia), US East (Ohio), US
	//    West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt),
	//    Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
	//    Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
	//
	//    * The environment type LINUX_GPU_CONTAINER is available only in regions
	//    US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central),
	//    EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia
	//    Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney) , China
	//    (Beijing), and China (Ningxia).
	//
	// Type is a required field
	Type EnvironmentType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectEnvironment) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectEnvironment"}
	if len(s.ComputeType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComputeType"))
	}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}
	if s.Image != nil && len(*s.Image) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Image", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.EnvironmentVariables != nil {
		for i, v := range s.EnvironmentVariables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentVariables", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RegistryCredential != nil {
		if err := s.RegistryCredential.Validate(); err != nil {
			invalidParams.AddNested("RegistryCredential", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a file system created by Amazon Elastic File System (EFS).
// For more information, see What Is Amazon Elastic File System? (https://docs.aws.amazon.com/efs/latest/ug/whatisefs.html)
type ProjectFileSystemLocation struct {
	_ struct{} `type:"structure"`

	// The name used to access a file system created by Amazon EFS. CodeBuild creates
	// an environment variable by appending the identifier in all capital letters
	// to CODEBUILD_. For example, if you specify my-efs for identifier, a new environment
	// variable is create named CODEBUILD_MY-EFS.
	//
	// The identifier is used to mount your file system.
	Identifier *string `locationName:"identifier" type:"string"`

	// A string that specifies the location of the file system created by Amazon
	// EFS. Its format is efs-dns-name:/directory-path. You can find the DNS name
	// of file system when you view it in the AWS EFS console. The directory path
	// is a path to a directory in the file system that CodeBuild mounts. For example,
	// if the DNS name of a file system is fs-abcd1234.efs.us-west-2.amazonaws.com,
	// and its mount directory is my-efs-mount-directory, then the location is fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory.
	//
	// The directory path in the format efs-dns-name:/directory-path is optional.
	// If you do not specify a directory path, the location is only the DNS name
	// and CodeBuild mounts the entire file system.
	Location *string `locationName:"location" type:"string"`

	// The mount options for a file system created by AWS EFS. The default mount
	// options used by CodeBuild are nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2.
	// For more information, see Recommended NFS Mount Options (https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html).
	MountOptions *string `locationName:"mountOptions" type:"string"`

	// The location in the container where you mount the file system.
	MountPoint *string `locationName:"mountPoint" type:"string"`

	// The type of the file system. The one supported type is EFS.
	Type FileSystemType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ProjectFileSystemLocation) String() string {
	return awsutil.Prettify(s)
}

// Information about the build input source code for the build project.
type ProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the authorization settings for AWS CodeBuild to access
	// the source code to be built.
	//
	// This information is for the AWS CodeBuild console's use only. Your code should
	// not get or set this information directly.
	Auth *SourceAuth `locationName:"auth" type:"structure"`

	// Contains information that defines how the build project reports the build
	// status to the source provider. This option is only used when the source provider
	// is GITHUB, GITHUB_ENTERPRISE, or BITBUCKET.
	BuildStatusConfig *BuildStatusConfig `locationName:"buildStatusConfig" type:"structure"`

	// The buildspec file declaration to use for the builds in this build project.
	//
	// If this value is set, it can be either an inline buildspec definition, the
	// path to an alternate buildspec file relative to the value of the built-in
	// CODEBUILD_SRC_DIR environment variable, or the path to an S3 bucket. The
	// bucket must be in the same AWS Region as the build project. Specify the buildspec
	// file using its ARN (for example, arn:aws:s3:::my-codebuild-sample2/buildspec.yml).
	// If this value is not provided or is set to an empty string, the source code
	// must contain a buildspec file in its root directory. For more information,
	// see Buildspec File Name and Storage Location (https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
	Buildspec *string `locationName:"buildspec" type:"string"`

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int64 `locationName:"gitCloneDepth" type:"integer"`

	// Information about the Git submodules configuration for the build project.
	GitSubmodulesConfig *GitSubmodulesConfig `locationName:"gitSubmodulesConfig" type:"structure"`

	// Enable this flag to ignore SSL warnings while connecting to the project source
	// code.
	InsecureSsl *bool `locationName:"insecureSsl" type:"boolean"`

	// Information about the location of the source code to be built. Valid values
	// include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in AWS CodePipeline, location should not be specified. If it
	//    is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline
	//    uses the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an AWS CodeCommit repository, the HTTPS clone URL
	//    to the repository that contains the source code and the buildspec file
	//    (for example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name
	//    ).
	//
	//    * For source code in an Amazon Simple Storage Service (Amazon S3) input
	//    bucket, one of the following. The path to the ZIP file that contains the
	//    source code (for example, bucket-name/path/to/object-name.zip). The path
	//    to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the buildspec file. You must connect your
	//    AWS account to your GitHub account. Use the AWS CodeBuild console to start
	//    creating a build project. When you use the console to connect (or reconnect)
	//    with GitHub, on the GitHub Authorize application page, for Organization
	//    access, choose Request access next to each repository you want to allow
	//    AWS CodeBuild to have access to, and then choose Authorize application.
	//    (After you have connected to your GitHub account, you do not need to finish
	//    creating the build project. You can leave the AWS CodeBuild console.)
	//    To instruct AWS CodeBuild to use this connection, in the source object,
	//    set the auth object's type value to OAUTH.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the buildspec file. You must connect
	//    your AWS account to your Bitbucket account. Use the AWS CodeBuild console
	//    to start creating a build project. When you use the console to connect
	//    (or reconnect) with Bitbucket, on the Bitbucket Confirm access to your
	//    account page, choose Grant access. (After you have connected to your Bitbucket
	//    account, you do not need to finish creating the build project. You can
	//    leave the AWS CodeBuild console.) To instruct AWS CodeBuild to use this
	//    connection, in the source object, set the auth object's type value to
	//    OAUTH.
	Location *string `locationName:"location" type:"string"`

	// Set to true to report the status of a build's start and finish to your source
	// provider. This option is valid only when your source provider is GitHub,
	// GitHub Enterprise, or Bitbucket. If this is set and you use a different source
	// provider, an invalidInputException is thrown.
	//
	// The status of a build triggered by a webhook is always reported to your source
	// provider.
	ReportBuildStatus *bool `locationName:"reportBuildStatus" type:"boolean"`

	// An identifier for this project source.
	SourceIdentifier *string `locationName:"sourceIdentifier" type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// include:
	//
	//    * BITBUCKET: The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT: The source code is in an AWS CodeCommit repository.
	//
	//    * CODEPIPELINE: The source code settings are specified in the source action
	//    of a pipeline in AWS CodePipeline.
	//
	//    * GITHUB: The source code is in a GitHub or GitHub Enterprise Cloud repository.
	//
	//    * GITHUB_ENTERPRISE: The source code is in a GitHub Enterprise Server
	//    repository.
	//
	//    * NO_SOURCE: The project does not have input source code.
	//
	//    * S3: The source code is in an Amazon Simple Storage Service (Amazon S3)
	//    input bucket.
	//
	// Type is a required field
	Type SourceType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectSource"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Auth != nil {
		if err := s.Auth.Validate(); err != nil {
			invalidParams.AddNested("Auth", err.(aws.ErrInvalidParams))
		}
	}
	if s.GitSubmodulesConfig != nil {
		if err := s.GitSubmodulesConfig.Validate(); err != nil {
			invalidParams.AddNested("GitSubmodulesConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A source identifier and its corresponding version.
type ProjectSourceVersion struct {
	_ struct{} `type:"structure"`

	// An identifier for a source in the build project.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `locationName:"sourceIdentifier" type:"string" required:"true"`

	// The source version for the corresponding source identifier. If specified,
	// must be one of:
	//
	//    * For AWS CodeCommit: the commit ID, branch, or Git tag to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example, pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	//
	// For more information, see Source Version Sample with CodeBuild (https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
	// in the AWS CodeBuild User Guide.
	//
	// SourceVersion is a required field
	SourceVersion *string `locationName:"sourceVersion" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectSourceVersion) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectSourceVersion) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectSourceVersion"}

	if s.SourceIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceIdentifier"))
	}

	if s.SourceVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about credentials that provide access to a private Docker registry.
// When this is set:
//
//    * imagePullCredentialsType must be set to SERVICE_ROLE.
//
//    * images cannot be curated or an Amazon ECR image.
//
// For more information, see Private Registry with AWS Secrets Manager Sample
// for AWS CodeBuild (https://docs.aws.amazon.com/codebuild/latest/userguide/sample-private-registry.html).
type RegistryCredential struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets
	// Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current AWS Region.
	//
	// Credential is a required field
	Credential *string `locationName:"credential" min:"1" type:"string" required:"true"`

	// The service that created the credentials to access a private Docker registry.
	// The valid value, SECRETS_MANAGER, is for AWS Secrets Manager.
	//
	// CredentialProvider is a required field
	CredentialProvider CredentialProviderType `locationName:"credentialProvider" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegistryCredential) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegistryCredential"}

	if s.Credential == nil {
		invalidParams.Add(aws.NewErrParamRequired("Credential"))
	}
	if s.Credential != nil && len(*s.Credential) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Credential", 1))
	}
	if len(s.CredentialProvider) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CredentialProvider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the results from running a series of test cases during
// the run of a build project. The test cases are specified in the buildspec
// for the build project using one or more paths to the test case files. You
// can specify any type of tests you want, such as unit tests, integration tests,
// and functional tests.
type Report struct {
	_ struct{} `type:"structure"`

	// The ARN of the report run.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The date and time this report run occurred.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The ARN of the build run that generated this report.
	ExecutionId *string `locationName:"executionId" type:"string"`

	// The date and time a report expires. A report expires 30 days after it is
	// created. An expired report is not available to view in CodeBuild.
	Expired *time.Time `locationName:"expired" type:"timestamp"`

	// Information about where the raw data used to generate this report was exported.
	ExportConfig *ReportExportConfig `locationName:"exportConfig" type:"structure"`

	// The name of the report that was run.
	Name *string `locationName:"name" type:"string"`

	// The ARN of the report group associated with this report.
	ReportGroupArn *string `locationName:"reportGroupArn" min:"1" type:"string"`

	// The status of this report.
	Status ReportStatusType `locationName:"status" type:"string" enum:"true"`

	// A TestReportSummary object that contains information about this test report.
	TestSummary *TestReportSummary `locationName:"testSummary" type:"structure"`

	// A boolean that specifies if this report run is truncated. The list of test
	// cases is truncated after the maximum number of test cases is reached.
	Truncated *bool `locationName:"truncated" type:"boolean"`

	// The type of the report that was run.
	Type ReportType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Report) String() string {
	return awsutil.Prettify(s)
}

// Information about the location where the run of a report is exported.
type ReportExportConfig struct {
	_ struct{} `type:"structure"`

	// The export configuration type. Valid values are:
	//
	//    * S3: The report results are exported to an S3 bucket.
	//
	//    * NO_EXPORT: The report results are not exported.
	ExportConfigType ReportExportConfigType `locationName:"exportConfigType" type:"string" enum:"true"`

	// A S3ReportExportConfig object that contains information about the S3 bucket
	// where the run of a report is exported.
	S3Destination *S3ReportExportConfig `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s ReportExportConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportExportConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReportExportConfig"}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A filter used to return reports with the status specified by the input status
// parameter.
type ReportFilter struct {
	_ struct{} `type:"structure"`

	// The status used to filter reports. You can filter using one status only.
	Status ReportStatusType `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ReportFilter) String() string {
	return awsutil.Prettify(s)
}

// A series of reports. Each report contains information about the results from
// running a series of test cases. You specify the test cases for a report group
// in the buildspec for a build project using one or more paths to the test
// case files.
type ReportGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of a ReportGroup.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The date and time this ReportGroup was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// Information about the destination where the raw data of this ReportGroup
	// is exported.
	ExportConfig *ReportExportConfig `locationName:"exportConfig" type:"structure"`

	// The date and time this ReportGroup was last modified.
	LastModified *time.Time `locationName:"lastModified" type:"timestamp"`

	// The name of a ReportGroup.
	Name *string `locationName:"name" min:"2" type:"string"`

	// A list of tag key and value pairs associated with this report group.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// report group tags.
	Tags []Tag `locationName:"tags" type:"list"`

	// The type of the ReportGroup. The one valid value is TEST.
	Type ReportType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ReportGroup) String() string {
	return awsutil.Prettify(s)
}

// Information about S3 logs for a build project.
type S3LogsConfig struct {
	_ struct{} `type:"structure"`

	// Set to true if you do not want your S3 build log output encrypted. By default
	// S3 build logs are encrypted.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3
	// bucket name is my-bucket, and your path prefix is build-log, then acceptable
	// formats are my-bucket/build-log or arn:aws:s3:::my-bucket/build-log.
	Location *string `locationName:"location" type:"string"`

	// The current status of the S3 build logs. Valid values are:
	//
	//    * ENABLED: S3 build logs are enabled for this build project.
	//
	//    * DISABLED: S3 build logs are not enabled for this build project.
	//
	// Status is a required field
	Status LogsConfigStatusType `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s S3LogsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3LogsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3LogsConfig"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the S3 bucket where the raw data of a report are exported.
type S3ReportExportConfig struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the raw data of a report are exported.
	Bucket *string `locationName:"bucket" min:"1" type:"string"`

	// A boolean value that specifies if the results of a report are encrypted.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// The encryption key for the report's encrypted raw data.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The type of build output artifact to create. Valid values include:
	//
	//    * NONE: AWS CodeBuild creates the raw data in the output bucket. This
	//    is the default if packaging is not specified.
	//
	//    * ZIP: AWS CodeBuild creates a ZIP file with the raw data in the output
	//    bucket.
	Packaging ReportPackagingType `locationName:"packaging" type:"string" enum:"true"`

	// The path to the exported report's raw data results.
	Path *string `locationName:"path" type:"string"`
}

// String returns the string representation
func (s S3ReportExportConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReportExportConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ReportExportConfig"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 1))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EncryptionKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the authorization settings for AWS CodeBuild to access
// the source code to be built.
//
// This information is for the AWS CodeBuild console's use only. Your code should
// not get or set this information directly.
type SourceAuth struct {
	_ struct{} `type:"structure"`

	// The resource value that applies to the specified authorization type.
	Resource *string `locationName:"resource" type:"string"`

	//
	// This data type is deprecated and is no longer accurate or used.
	//
	// The authorization type to use. The only valid value is OAUTH, which represents
	// the OAuth authorization type.
	//
	// Type is a required field
	Type SourceAuthType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SourceAuth) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAuth) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceAuth"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the credentials for a GitHub, GitHub Enterprise, or Bitbucket
// repository.
type SourceCredentialsInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The type of authentication used by the credentials. Valid options are OAUTH,
	// BASIC_AUTH, or PERSONAL_ACCESS_TOKEN.
	AuthType AuthType `locationName:"authType" type:"string" enum:"true"`

	// The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE,
	// or BITBUCKET.
	ServerType ServerType `locationName:"serverType" type:"string" enum:"true"`
}

// String returns the string representation
func (s SourceCredentialsInfo) String() string {
	return awsutil.Prettify(s)
}

// A tag, consisting of a key and a value.
//
// This tag is available for use by AWS services that support tags in AWS CodeBuild.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The tag's value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a test case created using a framework such as NUnit or
// Cucumber. A test case might be a unit test or a configuration test.
type TestCase struct {
	_ struct{} `type:"structure"`

	// The number of nanoseconds it took to run this test case.
	DurationInNanoSeconds *int64 `locationName:"durationInNanoSeconds" type:"long"`

	// The date and time a test case expires. A test case expires 30 days after
	// it is created. An expired test case is not available to view in CodeBuild.
	Expired *time.Time `locationName:"expired" type:"timestamp"`

	// A message associated with a test case. For example, an error message or stack
	// trace.
	Message *string `locationName:"message" type:"string"`

	// The name of the test case.
	Name *string `locationName:"name" type:"string"`

	// A string that is applied to a series of related test cases. CodeBuild generates
	// the prefix. The prefix depends on the framework used to generate the tests.
	Prefix *string `locationName:"prefix" type:"string"`

	// The ARN of the report to which the test case belongs.
	ReportArn *string `locationName:"reportArn" min:"1" type:"string"`

	// The status returned by the test case after it was run. Valid statuses are
	// SUCCEEDED, FAILED, ERROR, SKIPPED, and UNKNOWN.
	Status *string `locationName:"status" type:"string"`

	// The path to the raw data file that contains the test result.
	TestRawDataPath *string `locationName:"testRawDataPath" type:"string"`
}

// String returns the string representation
func (s TestCase) String() string {
	return awsutil.Prettify(s)
}

// A filter used to return specific types of test cases.
type TestCaseFilter struct {
	_ struct{} `type:"structure"`

	// The status used to filter test cases. Valid statuses are SUCCEEDED, FAILED,
	// ERROR, SKIPPED, and UNKNOWN. A TestCaseFilter can have one status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s TestCaseFilter) String() string {
	return awsutil.Prettify(s)
}

// Information about a test report.
type TestReportSummary struct {
	_ struct{} `type:"structure"`

	// The number of nanoseconds it took to run all of the test cases in this report.
	//
	// DurationInNanoSeconds is a required field
	DurationInNanoSeconds *int64 `locationName:"durationInNanoSeconds" type:"long" required:"true"`

	// A map that contains the number of each type of status returned by the test
	// results in this TestReportSummary.
	//
	// StatusCounts is a required field
	StatusCounts map[string]int64 `locationName:"statusCounts" type:"map" required:"true"`

	// The number of test cases in this TestReportSummary. The total includes truncated
	// test cases.
	//
	// Total is a required field
	Total *int64 `locationName:"total" type:"integer" required:"true"`
}

// String returns the string representation
func (s TestReportSummary) String() string {
	return awsutil.Prettify(s)
}

// Information about the VPC configuration that AWS CodeBuild accesses.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security groups IDs in your Amazon VPC.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// A list of one or more subnet IDs in your Amazon VPC.
	Subnets []string `locationName:"subnets" type:"list"`

	// The ID of the Amazon VPC.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcConfig"}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a webhook that connects repository events to a build project
// in AWS CodeBuild.
type Webhook struct {
	_ struct{} `type:"structure"`

	// A regular expression used to determine which repository branches are built
	// when a webhook is triggered. If the name of a branch matches the regular
	// expression, then it is built. If branchFilter is empty, then all branches
	// are built.
	//
	// It is recommended that you use filterGroups instead of branchFilter.
	BranchFilter *string `locationName:"branchFilter" type:"string"`

	// An array of arrays of WebhookFilter objects used to determine which webhooks
	// are triggered. At least one WebhookFilter in the array must specify EVENT
	// as its type.
	//
	// For a build to be triggered, at least one filter group in the filterGroups
	// array must pass. For a filter group to pass, each of its filters must pass.
	FilterGroups [][]WebhookFilter `locationName:"filterGroups" type:"list"`

	// A timestamp that indicates the last time a repository's secret token was
	// modified.
	LastModifiedSecret *time.Time `locationName:"lastModifiedSecret" type:"timestamp"`

	// The AWS CodeBuild endpoint where webhook events are sent.
	PayloadUrl *string `locationName:"payloadUrl" min:"1" type:"string"`

	// The secret token of the associated repository.
	//
	// A Bitbucket webhook does not support secret.
	Secret *string `locationName:"secret" min:"1" type:"string"`

	// The URL to the webhook.
	Url *string `locationName:"url" min:"1" type:"string"`
}

// String returns the string representation
func (s Webhook) String() string {
	return awsutil.Prettify(s)
}

// A filter used to determine which webhooks trigger a build.
type WebhookFilter struct {
	_ struct{} `type:"structure"`

	// Used to indicate that the pattern determines which webhook events do not
	// trigger a build. If true, then a webhook event that does not match the pattern
	// triggers a build. If false, then a webhook event that matches the pattern
	// triggers a build.
	ExcludeMatchedPattern *bool `locationName:"excludeMatchedPattern" type:"boolean"`

	// For a WebHookFilter that uses EVENT type, a comma-separated string that specifies
	// one or more events. For example, the webhook filter PUSH, PULL_REQUEST_CREATED,
	// PULL_REQUEST_UPDATED allows all push, pull request created, and pull request
	// updated events to trigger a build.
	//
	// For a WebHookFilter that uses any of the other filter types, a regular expression
	// pattern. For example, a WebHookFilter that uses HEAD_REF for its type and
	// the pattern ^refs/heads/ triggers a build when the head reference is a branch
	// with a reference name refs/heads/branch-name.
	//
	// Pattern is a required field
	Pattern *string `locationName:"pattern" type:"string" required:"true"`

	// The type of webhook filter. There are six webhook filter types: EVENT, ACTOR_ACCOUNT_ID,
	// HEAD_REF, BASE_REF, FILE_PATH, and COMMIT_MESSAGE.
	//
	// EVENT
	//
	// A webhook event triggers a build when the provided pattern matches one of
	// five event types: PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED, PULL_REQUEST_REOPENED,
	// and PULL_REQUEST_MERGED. The EVENT patterns are specified as a comma-separated
	// string. For example, PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED filters
	// all push, pull request created, and pull request updated events.
	//
	// The PULL_REQUEST_REOPENED works with GitHub and GitHub Enterprise only.
	//
	// ACTOR_ACCOUNT_ID
	//
	// A webhook event triggers a build when a GitHub, GitHub Enterprise, or Bitbucket
	// account ID matches the regular expression pattern.
	//
	// HEAD_REF
	//
	// A webhook event triggers a build when the head reference matches the regular
	// expression pattern. For example, refs/heads/branch-name and refs/tags/tag-name.
	//
	// Works with GitHub and GitHub Enterprise push, GitHub and GitHub Enterprise
	// pull request, Bitbucket push, and Bitbucket pull request events.
	//
	// BASE_REF
	//
	// A webhook event triggers a build when the base reference matches the regular
	// expression pattern. For example, refs/heads/branch-name.
	//
	// Works with pull request events only.
	//
	// FILE_PATH
	//
	// A webhook triggers a build when the path of a changed file matches the regular
	// expression pattern.
	//
	// Works with GitHub and Bitbucket events push and pull requests events. Also
	// works with GitHub Enterprise push events, but does not work with GitHub Enterprise
	// pull request events.
	//
	// COMMIT_MESSAGE
	//
	// A webhook triggers a build when the head commit message matches the regular
	// expression pattern.
	//
	// Works with GitHub and Bitbucket events push and pull requests events. Also
	// works with GitHub Enterprise push events, but does not work with GitHub Enterprise
	// pull request events.
	//
	// Type is a required field
	Type WebhookFilterType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s WebhookFilter) String() string {
	return awsutil.Prettify(s)
}
