// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribePackageVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository that contains the package
	// version.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// A format that specifies the type of the requested package version. The valid
	// values are:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the requested package version.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package version.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePackageVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackageVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePackageVersionInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.PackageVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageVersion", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribePackageVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageVersion != nil {
		v := *s.PackageVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribePackageVersionOutput struct {
	_ struct{} `type:"structure"`

	// A PackageVersionDescription (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html)
	// object that contains information about the requested package version.
	//
	// PackageVersion is a required field
	PackageVersion *PackageVersionDescription `locationName:"packageVersion" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribePackageVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribePackageVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PackageVersion != nil {
		v := s.PackageVersion

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "packageVersion", v, metadata)
	}
	return nil
}

const opDescribePackageVersion = "DescribePackageVersion"

// DescribePackageVersionRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns a PackageVersionDescription (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html)
// object that contains information about the requested package version.
//
//    // Example sending a request using DescribePackageVersionRequest.
//    req := client.DescribePackageVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackageVersion
func (c *Client) DescribePackageVersionRequest(input *DescribePackageVersionInput) DescribePackageVersionRequest {
	op := &aws.Operation{
		Name:       opDescribePackageVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/package/version",
	}

	if input == nil {
		input = &DescribePackageVersionInput{}
	}

	req := c.newRequest(op, input, &DescribePackageVersionOutput{})

	return DescribePackageVersionRequest{Request: req, Input: input, Copy: c.DescribePackageVersionRequest}
}

// DescribePackageVersionRequest is the request type for the
// DescribePackageVersion API operation.
type DescribePackageVersionRequest struct {
	*aws.Request
	Input *DescribePackageVersionInput
	Copy  func(*DescribePackageVersionInput) DescribePackageVersionRequest
}

// Send marshals and sends the DescribePackageVersion API request.
func (r DescribePackageVersionRequest) Send(ctx context.Context) (*DescribePackageVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePackageVersionResponse{
		DescribePackageVersionOutput: r.Request.Data.(*DescribePackageVersionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePackageVersionResponse is the response type for the
// DescribePackageVersion API operation.
type DescribePackageVersionResponse struct {
	*DescribePackageVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePackageVersion request.
func (r *DescribePackageVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
