// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteRepositoryPermissionsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the repository associated with the resource
	// policy to be deleted.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The revision of the repository's resource policy to be deleted. This revision
	// is used for optimistic locking, which prevents others from accidentally overwriting
	// your changes to the repository's resource policy.
	PolicyRevision *string `location:"querystring" locationName:"policy-revision" min:"1" type:"string"`

	// The name of the repository that is associated with the resource policy to
	// be deleted
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryPermissionsPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRepositoryPermissionsPolicyInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyRevision", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRepositoryPermissionsPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyRevision != nil {
		v := *s.PolicyRevision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "policy-revision", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteRepositoryPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted policy after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation
func (s DeleteRepositoryPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRepositoryPermissionsPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := s.Policy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "policy", v, metadata)
	}
	return nil
}

const opDeleteRepositoryPermissionsPolicy = "DeleteRepositoryPermissionsPolicy"

// DeleteRepositoryPermissionsPolicyRequest returns a request value for making API operation for
// CodeArtifact.
//
// Deletes the resource policy that is set on a repository. After a resource
// policy is deleted, the permissions allowed and denied by the deleted policy
// are removed. The effect of deleting a resource policy might not be immediate.
//
// Use DeleteRepositoryPermissionsPolicy with caution. After a policy is deleted,
// AWS users, roles, and accounts lose permissions to perform the repository
// actions granted by the deleted policy.
//
//    // Example sending a request using DeleteRepositoryPermissionsPolicyRequest.
//    req := client.DeleteRepositoryPermissionsPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepositoryPermissionsPolicy
func (c *Client) DeleteRepositoryPermissionsPolicyRequest(input *DeleteRepositoryPermissionsPolicyInput) DeleteRepositoryPermissionsPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteRepositoryPermissionsPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/repository/permissions/policies",
	}

	if input == nil {
		input = &DeleteRepositoryPermissionsPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteRepositoryPermissionsPolicyOutput{})

	return DeleteRepositoryPermissionsPolicyRequest{Request: req, Input: input, Copy: c.DeleteRepositoryPermissionsPolicyRequest}
}

// DeleteRepositoryPermissionsPolicyRequest is the request type for the
// DeleteRepositoryPermissionsPolicy API operation.
type DeleteRepositoryPermissionsPolicyRequest struct {
	*aws.Request
	Input *DeleteRepositoryPermissionsPolicyInput
	Copy  func(*DeleteRepositoryPermissionsPolicyInput) DeleteRepositoryPermissionsPolicyRequest
}

// Send marshals and sends the DeleteRepositoryPermissionsPolicy API request.
func (r DeleteRepositoryPermissionsPolicyRequest) Send(ctx context.Context) (*DeleteRepositoryPermissionsPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRepositoryPermissionsPolicyResponse{
		DeleteRepositoryPermissionsPolicyOutput: r.Request.Data.(*DeleteRepositoryPermissionsPolicyOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRepositoryPermissionsPolicyResponse is the response type for the
// DeleteRepositoryPermissionsPolicy API operation.
type DeleteRepositoryPermissionsPolicyResponse struct {
	*DeleteRepositoryPermissionsPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRepositoryPermissionsPolicy request.
func (r *DeleteRepositoryPermissionsPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
