// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// A description of the created repository.
	Description *string `locationName:"description" type:"string"`

	// The domain that contains the created repository.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the repository to create.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// A list of upstream repositories to associate with the repository. The order
	// of the upstream repositories in the list determines their priority order
	// when AWS CodeArtifact looks for a requested package version. For more information,
	// see Working with upstream repositories (https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
	Upstreams []UpstreamRepository `locationName:"upstreams" type:"list"`
}

// String returns the string representation
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRepositoryInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}
	if s.Upstreams != nil {
		for i, v := range s.Upstreams {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Upstreams", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRepositoryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Upstreams != nil {
		v := s.Upstreams

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "upstreams", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the created repository after processing the request.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRepositoryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Repository != nil {
		v := s.Repository

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "repository", v, metadata)
	}
	return nil
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest returns a request value for making API operation for
// CodeArtifact.
//
// Creates a repository.
//
//    // Example sending a request using CreateRepositoryRequest.
//    req := client.CreateRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateRepository
func (c *Client) CreateRepositoryRequest(input *CreateRepositoryInput) CreateRepositoryRequest {
	op := &aws.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/repository",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	req := c.newRequest(op, input, &CreateRepositoryOutput{})

	return CreateRepositoryRequest{Request: req, Input: input, Copy: c.CreateRepositoryRequest}
}

// CreateRepositoryRequest is the request type for the
// CreateRepository API operation.
type CreateRepositoryRequest struct {
	*aws.Request
	Input *CreateRepositoryInput
	Copy  func(*CreateRepositoryInput) CreateRepositoryRequest
}

// Send marshals and sends the CreateRepository API request.
func (r CreateRepositoryRequest) Send(ctx context.Context) (*CreateRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRepositoryResponse{
		CreateRepositoryOutput: r.Request.Data.(*CreateRepositoryOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRepositoryResponse is the response type for the
// CreateRepository API operation.
type CreateRepositoryResponse struct {
	*CreateRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRepository request.
func (r *CreateRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
