// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CopyPackageVersionsInput struct {
	_ struct{} `type:"structure"`

	// Set to true to overwrite a package version that already exists in the destination
	// repository. If set to false and the package version already exists in the
	// destination repository, the package version is returned in the failedVersions
	// field of the response with an ALREADY_EXISTS error code.
	AllowOverwrite *bool `locationName:"allowOverwrite" type:"boolean"`

	// The name of the repository into which package versions are copied.
	//
	// DestinationRepository is a required field
	DestinationRepository *string `location:"querystring" locationName:"destination-repository" min:"2" type:"string" required:"true"`

	// The name of the domain that contains the source and destination repositories.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the package that is copied. The valid package types are:
	//
	//    * npm: A Node Package Manager (npm) package.
	//
	//    * pypi: A Python Package Index (PyPI) package.
	//
	//    * maven: A Maven package that contains compiled code in a distributable
	//    format, such as a JAR file.
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// Set to true to copy packages from repositories that are upstream from the
	// source repository to the destination repository. The default setting is false.
	// For more information, see Working with upstream repositories (https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
	IncludeFromUpstream *bool `locationName:"includeFromUpstream" type:"boolean"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The name of the package that is copied.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the package versions to copy.
	//
	// SourceRepository is a required field
	SourceRepository *string `location:"querystring" locationName:"source-repository" min:"2" type:"string" required:"true"`

	// A list of key-value pairs. The keys are package versions and the values are
	// package version revisions. A CopyPackageVersion operation succeeds if the
	// specified versions in the source repository match the specified package version
	// revision.
	//
	// You must specify versions or versionRevisions. You cannot specify both.
	VersionRevisions map[string]string `locationName:"versionRevisions" type:"map"`

	// The versions of the package to copy.
	//
	// You must specify versions or versionRevisions. You cannot specify both.
	Versions []string `locationName:"versions" type:"list"`
}

// String returns the string representation
func (s CopyPackageVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyPackageVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopyPackageVersionsInput"}

	if s.DestinationRepository == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationRepository"))
	}
	if s.DestinationRepository != nil && len(*s.DestinationRepository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationRepository", 2))
	}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.SourceRepository == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceRepository"))
	}
	if s.SourceRepository != nil && len(*s.SourceRepository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceRepository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyPackageVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AllowOverwrite != nil {
		v := *s.AllowOverwrite

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowOverwrite", protocol.BoolValue(v), metadata)
	}
	if s.IncludeFromUpstream != nil {
		v := *s.IncludeFromUpstream

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "includeFromUpstream", protocol.BoolValue(v), metadata)
	}
	if s.VersionRevisions != nil {
		v := s.VersionRevisions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "versionRevisions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Versions != nil {
		v := s.Versions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.DestinationRepository != nil {
		v := *s.DestinationRepository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "destination-repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceRepository != nil {
		v := *s.SourceRepository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "source-repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CopyPackageVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A map of package versions that failed to copy and their error codes. The
	// possible error codes are in the PackageVersionError data type. They are:
	//
	//    * ALREADY_EXISTS
	//
	//    * MISMATCHED_REVISION
	//
	//    * MISMATCHED_STATUS
	//
	//    * NOT_ALLOWED
	//
	//    * NOT_FOUND
	//
	//    * SKIPPED
	FailedVersions map[string]PackageVersionError `locationName:"failedVersions" type:"map"`

	// A list of the package versions that were successfully copied to your repository.
	SuccessfulVersions map[string]SuccessfulPackageVersionInfo `locationName:"successfulVersions" type:"map"`
}

// String returns the string representation
func (s CopyPackageVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyPackageVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FailedVersions != nil {
		v := s.FailedVersions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "failedVersions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.SuccessfulVersions != nil {
		v := s.SuccessfulVersions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "successfulVersions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

const opCopyPackageVersions = "CopyPackageVersions"

// CopyPackageVersionsRequest returns a request value for making API operation for
// CodeArtifact.
//
// Copies package versions from one repository to another repository in the
// same domain.
//
// You must specify versions or versionRevisions. You cannot specify both.
//
//    // Example sending a request using CopyPackageVersionsRequest.
//    req := client.CopyPackageVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CopyPackageVersions
func (c *Client) CopyPackageVersionsRequest(input *CopyPackageVersionsInput) CopyPackageVersionsRequest {
	op := &aws.Operation{
		Name:       opCopyPackageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/versions/copy",
	}

	if input == nil {
		input = &CopyPackageVersionsInput{}
	}

	req := c.newRequest(op, input, &CopyPackageVersionsOutput{})

	return CopyPackageVersionsRequest{Request: req, Input: input, Copy: c.CopyPackageVersionsRequest}
}

// CopyPackageVersionsRequest is the request type for the
// CopyPackageVersions API operation.
type CopyPackageVersionsRequest struct {
	*aws.Request
	Input *CopyPackageVersionsInput
	Copy  func(*CopyPackageVersionsInput) CopyPackageVersionsRequest
}

// Send marshals and sends the CopyPackageVersions API request.
func (r CopyPackageVersionsRequest) Send(ctx context.Context) (*CopyPackageVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CopyPackageVersionsResponse{
		CopyPackageVersionsOutput: r.Request.Data.(*CopyPackageVersionsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CopyPackageVersionsResponse is the response type for the
// CopyPackageVersions API operation.
type CopyPackageVersionsResponse struct {
	*CopyPackageVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CopyPackageVersions request.
func (r *CopyPackageVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
