// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeQueryDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	QueryDefinitionNamePrefix *string `locationName:"queryDefinitionNamePrefix" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeQueryDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeQueryDefinitionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeQueryDefinitionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.QueryDefinitionNamePrefix != nil && len(*s.QueryDefinitionNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryDefinitionNamePrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeQueryDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	QueryDefinitions []QueryDefinition `locationName:"queryDefinitions" type:"list"`
}

// String returns the string representation
func (s DescribeQueryDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeQueryDefinitions = "DescribeQueryDefinitions"

// DescribeQueryDefinitionsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
//    // Example sending a request using DescribeQueryDefinitionsRequest.
//    req := client.DescribeQueryDefinitionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueryDefinitions
func (c *Client) DescribeQueryDefinitionsRequest(input *DescribeQueryDefinitionsInput) DescribeQueryDefinitionsRequest {
	op := &aws.Operation{
		Name:       opDescribeQueryDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeQueryDefinitionsInput{}
	}

	req := c.newRequest(op, input, &DescribeQueryDefinitionsOutput{})

	return DescribeQueryDefinitionsRequest{Request: req, Input: input, Copy: c.DescribeQueryDefinitionsRequest}
}

// DescribeQueryDefinitionsRequest is the request type for the
// DescribeQueryDefinitions API operation.
type DescribeQueryDefinitionsRequest struct {
	*aws.Request
	Input *DescribeQueryDefinitionsInput
	Copy  func(*DescribeQueryDefinitionsInput) DescribeQueryDefinitionsRequest
}

// Send marshals and sends the DescribeQueryDefinitions API request.
func (r DescribeQueryDefinitionsRequest) Send(ctx context.Context) (*DescribeQueryDefinitionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeQueryDefinitionsResponse{
		DescribeQueryDefinitionsOutput: r.Request.Data.(*DescribeQueryDefinitionsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeQueryDefinitionsResponse is the response type for the
// DescribeQueryDefinitions API operation.
type DescribeQueryDefinitionsResponse struct {
	*DescribeQueryDefinitionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeQueryDefinitions request.
func (r *DescribeQueryDefinitionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
