// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsmv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// One or more filters to limit the items returned in the response.
	//
	// Use the clusterIds filter to return only the specified clusters. Specify
	// clusters by their cluster identifier (ID).
	//
	// Use the vpcIds filter to return only the clusters in the specified virtual
	// private clouds (VPCs). Specify VPCs by their VPC identifier (ID).
	//
	// Use the states filter to return only clusters that match the specified state.
	Filters map[string][]string `type:"map"`

	// The maximum number of clusters to return in the response. When there are
	// more clusters than the number you specify, the response contains a NextToken
	// value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value that you received in the previous response. Use this
	// value to get more clusters.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClustersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of clusters.
	Clusters []Cluster `type:"list"`

	// An opaque string that indicates that the response contains only a subset
	// of clusters. Use this value in a subsequent DescribeClusters request to get
	// more clusters.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest returns a request value for making API operation for
// AWS CloudHSM V2.
//
// Gets information about AWS CloudHSM clusters.
//
// This is a paginated operation, which means that each response might contain
// only a subset of all the clusters. When the response contains only a subset
// of clusters, it includes a NextToken value. Use this value in a subsequent
// DescribeClusters request to get more clusters. When you receive a response
// with no NextToken (or an empty or null value), that means there are no more
// clusters to get.
//
//    // Example sending a request using DescribeClustersRequest.
//    req := client.DescribeClustersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DescribeClusters
func (c *Client) DescribeClustersRequest(input *DescribeClustersInput) DescribeClustersRequest {
	op := &aws.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	req := c.newRequest(op, input, &DescribeClustersOutput{})

	return DescribeClustersRequest{Request: req, Input: input, Copy: c.DescribeClustersRequest}
}

// DescribeClustersRequest is the request type for the
// DescribeClusters API operation.
type DescribeClustersRequest struct {
	*aws.Request
	Input *DescribeClustersInput
	Copy  func(*DescribeClustersInput) DescribeClustersRequest
}

// Send marshals and sends the DescribeClusters API request.
func (r DescribeClustersRequest) Send(ctx context.Context) (*DescribeClustersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClustersResponse{
		DescribeClustersOutput: r.Request.Data.(*DescribeClustersOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeClustersRequestPaginator returns a paginator for DescribeClusters.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeClustersRequest(input)
//   p := cloudhsmv2.NewDescribeClustersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeClustersPaginator(req DescribeClustersRequest) DescribeClustersPaginator {
	return DescribeClustersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeClustersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeClustersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeClustersPaginator struct {
	aws.Pager
}

func (p *DescribeClustersPaginator) CurrentPage() *DescribeClustersOutput {
	return p.Pager.CurrentPage().(*DescribeClustersOutput)
}

// DescribeClustersResponse is the response type for the
// DescribeClusters API operation.
type DescribeClustersResponse struct {
	*DescribeClustersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClusters request.
func (r *DescribeClustersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
