// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the ModifyHsm operation.
type ModifyHsmInput struct {
	_ struct{} `locationName:"ModifyHsmRequest" type:"structure"`

	// The new IP address for the elastic network interface (ENI) attached to the
	// HSM.
	//
	// If the HSM is moved to a different subnet, and an IP address is not specified,
	// an IP address will be randomly chosen from the CIDR range of the new subnet.
	EniIp *string `locationName:"EniIp" type:"string"`

	// The new external ID.
	ExternalId *string `locationName:"ExternalId" type:"string"`

	// The ARN of the HSM to modify.
	//
	// HsmArn is a required field
	HsmArn *string `locationName:"HsmArn" type:"string" required:"true"`

	// The new IAM role ARN.
	IamRoleArn *string `locationName:"IamRoleArn" type:"string"`

	// The new identifier of the subnet that the HSM is in. The new subnet must
	// be in the same Availability Zone as the current subnet.
	SubnetId *string `locationName:"SubnetId" type:"string"`

	// The new IP address for the syslog monitoring server. The AWS CloudHSM service
	// only supports one syslog monitoring server.
	SyslogIp *string `locationName:"SyslogIp" type:"string"`
}

// String returns the string representation
func (s ModifyHsmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyHsmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyHsmInput"}

	if s.HsmArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HsmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the ModifyHsm operation.
type ModifyHsmOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyHsmOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyHsm = "ModifyHsm"

// ModifyHsmRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Modifies an HSM.
//
// This operation can result in the HSM being offline for up to 15 minutes while
// the AWS CloudHSM service is reconfigured. If you are modifying a production
// HSM, you should ensure that your AWS CloudHSM service is configured for high
// availability, and consider executing this operation during a maintenance
// window.
//
//    // Example sending a request using ModifyHsmRequest.
//    req := client.ModifyHsmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsm
func (c *Client) ModifyHsmRequest(input *ModifyHsmInput) ModifyHsmRequest {
	op := &aws.Operation{
		Name:       opModifyHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHsmInput{}
	}

	req := c.newRequest(op, input, &ModifyHsmOutput{})

	return ModifyHsmRequest{Request: req, Input: input, Copy: c.ModifyHsmRequest}
}

// ModifyHsmRequest is the request type for the
// ModifyHsm API operation.
type ModifyHsmRequest struct {
	*aws.Request
	Input *ModifyHsmInput
	Copy  func(*ModifyHsmInput) ModifyHsmRequest
}

// Send marshals and sends the ModifyHsm API request.
func (r ModifyHsmRequest) Send(ctx context.Context) (*ModifyHsmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyHsmResponse{
		ModifyHsmOutput: r.Request.Data.(*ModifyHsmOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyHsmResponse is the response type for the
// ModifyHsm API operation.
type ModifyHsmResponse struct {
	*ModifyHsmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyHsm request.
func (r *ModifyHsmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
