// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the DeleteHsm operation.
type DeleteHsmInput struct {
	_ struct{} `locationName:"DeleteHsmRequest" type:"structure"`

	// The ARN of the HSM to delete.
	//
	// HsmArn is a required field
	HsmArn *string `locationName:"HsmArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteHsmInput"}

	if s.HsmArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HsmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the DeleteHsm operation.
type DeleteHsmOutput struct {
	_ struct{} `type:"structure"`

	// The status of the operation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteHsm = "DeleteHsm"

// DeleteHsmRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Deletes an HSM. After completion, this operation cannot be undone and your
// key material cannot be recovered.
//
//    // Example sending a request using DeleteHsmRequest.
//    req := client.DeleteHsmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsm
func (c *Client) DeleteHsmRequest(input *DeleteHsmInput) DeleteHsmRequest {
	op := &aws.Operation{
		Name:       opDeleteHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmInput{}
	}

	req := c.newRequest(op, input, &DeleteHsmOutput{})

	return DeleteHsmRequest{Request: req, Input: input, Copy: c.DeleteHsmRequest}
}

// DeleteHsmRequest is the request type for the
// DeleteHsm API operation.
type DeleteHsmRequest struct {
	*aws.Request
	Input *DeleteHsmInput
	Copy  func(*DeleteHsmInput) DeleteHsmRequest
}

// Send marshals and sends the DeleteHsm API request.
func (r DeleteHsmRequest) Send(ctx context.Context) (*DeleteHsmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteHsmResponse{
		DeleteHsmOutput: r.Request.Data.(*DeleteHsmOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteHsmResponse is the response type for the
// DeleteHsm API operation.
type DeleteHsmResponse struct {
	*DeleteHsmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteHsm request.
func (r *DeleteHsmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
