// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateCachePolicyInput struct {
	_ struct{} `type:"structure" payload:"CachePolicyConfig"`

	// A cache policy configuration.
	//
	// CachePolicyConfig is a required field
	CachePolicyConfig *CachePolicyConfig `locationName:"CachePolicyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The unique identifier for the cache policy that you are updating. The identifier
	// is returned in a cache behavior’s CachePolicyId field in the response to
	// GetDistributionConfig.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the cache policy that you are updating. The version is returned
	// in the cache policy’s ETag field in the response to GetCachePolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCachePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCachePolicyInput"}

	if s.CachePolicyConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("CachePolicyConfig"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.CachePolicyConfig != nil {
		if err := s.CachePolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("CachePolicyConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateCachePolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.CachePolicyConfig != nil {
		v := s.CachePolicyConfig

		metadata := protocol.Metadata{XMLNamespaceURI: "http://cloudfront.amazonaws.com/doc/2020-05-31/"}
		e.SetFields(protocol.PayloadTarget, "CachePolicyConfig", v, metadata)
	}
	return nil
}

type UpdateCachePolicyOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicy"`

	// A cache policy.
	CachePolicy *CachePolicy `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateCachePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.CachePolicy != nil {
		v := s.CachePolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CachePolicy", v, metadata)
	}
	return nil
}

const opUpdateCachePolicy = "UpdateCachePolicy2020_05_31"

// UpdateCachePolicyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Updates a cache policy configuration.
//
// When you update a cache policy configuration, all the fields are updated
// with the values provided in the request. You cannot update some fields independent
// of others. To update a cache policy configuration:
//
// Use GetCachePolicyConfig to get the current configuration.
//
// Locally modify the fields in the cache policy configuration that you want
// to update.
//
// Call UpdateCachePolicy by providing the entire cache policy configuration,
// including the fields that you modified and those that you didn’t.
//
//    // Example sending a request using UpdateCachePolicyRequest.
//    req := client.UpdateCachePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy
func (c *Client) UpdateCachePolicyRequest(input *UpdateCachePolicyInput) UpdateCachePolicyRequest {
	op := &aws.Operation{
		Name:       opUpdateCachePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}",
	}

	if input == nil {
		input = &UpdateCachePolicyInput{}
	}

	req := c.newRequest(op, input, &UpdateCachePolicyOutput{})

	return UpdateCachePolicyRequest{Request: req, Input: input, Copy: c.UpdateCachePolicyRequest}
}

// UpdateCachePolicyRequest is the request type for the
// UpdateCachePolicy API operation.
type UpdateCachePolicyRequest struct {
	*aws.Request
	Input *UpdateCachePolicyInput
	Copy  func(*UpdateCachePolicyInput) UpdateCachePolicyRequest
}

// Send marshals and sends the UpdateCachePolicy API request.
func (r UpdateCachePolicyRequest) Send(ctx context.Context) (*UpdateCachePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateCachePolicyResponse{
		UpdateCachePolicyOutput: r.Request.Data.(*UpdateCachePolicyOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateCachePolicyResponse is the response type for the
// UpdateCachePolicy API operation.
type UpdateCachePolicyResponse struct {
	*UpdateCachePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateCachePolicy request.
func (r *UpdateCachePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
