// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type DeleteFieldLevelEncryptionConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the configuration you want to delete from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the configuration
	// identity to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFieldLevelEncryptionConfigInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFieldLevelEncryptionConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFieldLevelEncryptionConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFieldLevelEncryptionConfig = "DeleteFieldLevelEncryptionConfig2020_05_31"

// DeleteFieldLevelEncryptionConfigRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Remove a field-level encryption configuration.
//
//    // Example sending a request using DeleteFieldLevelEncryptionConfigRequest.
//    req := client.DeleteFieldLevelEncryptionConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig
func (c *Client) DeleteFieldLevelEncryptionConfigRequest(input *DeleteFieldLevelEncryptionConfigInput) DeleteFieldLevelEncryptionConfigRequest {
	op := &aws.Operation{
		Name:       opDeleteFieldLevelEncryptionConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/field-level-encryption/{Id}",
	}

	if input == nil {
		input = &DeleteFieldLevelEncryptionConfigInput{}
	}

	req := c.newRequest(op, input, &DeleteFieldLevelEncryptionConfigOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteFieldLevelEncryptionConfigRequest{Request: req, Input: input, Copy: c.DeleteFieldLevelEncryptionConfigRequest}
}

// DeleteFieldLevelEncryptionConfigRequest is the request type for the
// DeleteFieldLevelEncryptionConfig API operation.
type DeleteFieldLevelEncryptionConfigRequest struct {
	*aws.Request
	Input *DeleteFieldLevelEncryptionConfigInput
	Copy  func(*DeleteFieldLevelEncryptionConfigInput) DeleteFieldLevelEncryptionConfigRequest
}

// Send marshals and sends the DeleteFieldLevelEncryptionConfig API request.
func (r DeleteFieldLevelEncryptionConfigRequest) Send(ctx context.Context) (*DeleteFieldLevelEncryptionConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFieldLevelEncryptionConfigResponse{
		DeleteFieldLevelEncryptionConfigOutput: r.Request.Data.(*DeleteFieldLevelEncryptionConfigOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFieldLevelEncryptionConfigResponse is the response type for the
// DeleteFieldLevelEncryptionConfig API operation.
type DeleteFieldLevelEncryptionConfigResponse struct {
	*DeleteFieldLevelEncryptionConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFieldLevelEncryptionConfig request.
func (r *DeleteFieldLevelEncryptionConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
