// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

// This action deletes a web distribution. To delete a web distribution using
// the CloudFront API, perform the following steps.
//
// To delete a web distribution using the CloudFront API:
//
// Disable the web distribution
//
// Submit a GET Distribution Config request to get the current configuration
// and the Etag header for the distribution.
//
// Update the XML document that was returned in the response to your GET Distribution
// Config request to change the value of Enabled to false.
//
// Submit a PUT Distribution Config request to update the configuration for
// your distribution. In the request body, include the XML document that you
// updated in Step 3. Set the value of the HTTP If-Match header to the value
// of the ETag header that CloudFront returned when you submitted the GET Distribution
// Config request in Step 2.
//
// Review the response to the PUT Distribution Config request to confirm that
// the distribution was successfully disabled.
//
// Submit a GET Distribution request to confirm that your changes have propagated.
// When propagation is complete, the value of Status is Deployed.
//
// Submit a DELETE Distribution request. Set the value of the HTTP If-Match
// header to the value of the ETag header that CloudFront returned when you
// submitted the GET Distribution Config request in Step 6.
//
// Review the response to your DELETE Distribution request to confirm that the
// distribution was successfully deleted.
//
// For information about deleting a distribution using the CloudFront console,
// see Deleting a Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html)
// in the Amazon CloudFront Developer Guide.
type DeleteDistributionInput struct {
	_ struct{} `type:"structure"`

	// The distribution ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when you disabled the distribution.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDistributionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDistributionInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDistributionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteDistributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDistributionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDistribution = "DeleteDistribution2020_05_31"

// DeleteDistributionRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Delete a distribution.
//
//    // Example sending a request using DeleteDistributionRequest.
//    req := client.DeleteDistributionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution
func (c *Client) DeleteDistributionRequest(input *DeleteDistributionInput) DeleteDistributionRequest {
	op := &aws.Operation{
		Name:       opDeleteDistribution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/distribution/{Id}",
	}

	if input == nil {
		input = &DeleteDistributionInput{}
	}

	req := c.newRequest(op, input, &DeleteDistributionOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteDistributionRequest{Request: req, Input: input, Copy: c.DeleteDistributionRequest}
}

// DeleteDistributionRequest is the request type for the
// DeleteDistribution API operation.
type DeleteDistributionRequest struct {
	*aws.Request
	Input *DeleteDistributionInput
	Copy  func(*DeleteDistributionInput) DeleteDistributionRequest
}

// Send marshals and sends the DeleteDistribution API request.
func (r DeleteDistributionRequest) Send(ctx context.Context) (*DeleteDistributionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDistributionResponse{
		DeleteDistributionOutput: r.Request.Data.(*DeleteDistributionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDistributionResponse is the response type for the
// DeleteDistribution API operation.
type DeleteDistributionResponse struct {
	*DeleteDistributionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDistribution request.
func (r *DeleteDistributionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
