// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterTypeInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that acts as an idempotency key for this registration
	// request. Specifying a client request token prevents CloudFormation from generating
	// more than one version of a type from the same registeration request, even
	// if the request is submitted multiple times.
	ClientRequestToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
	// when invoking the resource provider. If your resource type calls AWS APIs
	// in any of its handlers, you must create an IAM execution role (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
	// that includes the necessary permissions to call those AWS APIs, and provision
	// that execution role in your account. When CloudFormation needs to invoke
	// the resource provider handler, CloudFormation assumes this execution role
	// to create a temporary session token, which it then passes to the resource
	// provider handler, thereby supplying your resource provider with the appropriate
	// credentials.
	ExecutionRoleArn *string `min:"1" type:"string"`

	// Specifies logging configuration information for a type.
	LoggingConfig *LoggingConfig `type:"structure"`

	// A url to the S3 bucket containing the schema handler package that contains
	// the schema, event handlers, and associated files for the type you want to
	// register.
	//
	// For information on generating a schema handler package for the type you want
	// to register, see submit (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html)
	// in the CloudFormation CLI User Guide.
	//
	// As part of registering a resource provider type, CloudFormation must be able
	// to access the S3 bucket which contains the schema handler package for that
	// resource provider. For more information, see IAM Permissions for Registering
	// a Resource Provider (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-register-permissions)
	// in the AWS CloudFormation User Guide.
	//
	// SchemaHandlerPackage is a required field
	SchemaHandlerPackage *string `min:"1" type:"string" required:"true"`

	// The kind of type.
	//
	// Currently, the only valid value is RESOURCE.
	Type RegistryType `type:"string" enum:"true"`

	// The name of the type being registered.
	//
	// We recommend that type names adhere to the following pattern: company_or_organization::service::type.
	//
	// The following organization namespaces are reserved and cannot be used in
	// your resource type names:
	//
	//    * Alexa
	//
	//    * AMZN
	//
	//    * Amazon
	//
	//    * AWS
	//
	//    * Custom
	//
	//    * Dev
	//
	// TypeName is a required field
	TypeName *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterTypeInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionRoleArn", 1))
	}

	if s.SchemaHandlerPackage == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaHandlerPackage"))
	}
	if s.SchemaHandlerPackage != nil && len(*s.SchemaHandlerPackage) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SchemaHandlerPackage", 1))
	}

	if s.TypeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 10))
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterTypeOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for this registration request.
	//
	// Use this registration token when calling DescribeTypeRegistration , which
	// returns information about the status and IDs of the type registration.
	RegistrationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RegisterTypeOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterType = "RegisterType"

// RegisterTypeRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Registers a type with the CloudFormation service. Registering a type makes
// it available for use in CloudFormation templates in your AWS account, and
// includes:
//
//    * Validating the resource schema
//
//    * Determining which handlers have been specified for the resource
//
//    * Making the resource type available for use in your account
//
// For more information on how to develop types and ready them for registeration,
// see Creating Resource Providers (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html)
// in the CloudFormation CLI User Guide.
//
// You can have a maximum of 50 resource type versions registered at a time.
// This maximum is per account and per region. Use DeregisterType (AWSCloudFormation/latest/APIReference/API_DeregisterType.html)
// to deregister specific resource type versions if necessary.
//
// Once you have initiated a registration request using RegisterType , you can
// use DescribeTypeRegistration to monitor the progress of the registration
// request.
//
//    // Example sending a request using RegisterTypeRequest.
//    req := client.RegisterTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType
func (c *Client) RegisterTypeRequest(input *RegisterTypeInput) RegisterTypeRequest {
	op := &aws.Operation{
		Name:       opRegisterType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTypeInput{}
	}

	req := c.newRequest(op, input, &RegisterTypeOutput{})

	return RegisterTypeRequest{Request: req, Input: input, Copy: c.RegisterTypeRequest}
}

// RegisterTypeRequest is the request type for the
// RegisterType API operation.
type RegisterTypeRequest struct {
	*aws.Request
	Input *RegisterTypeInput
	Copy  func(*RegisterTypeInput) RegisterTypeRequest
}

// Send marshals and sends the RegisterType API request.
func (r RegisterTypeRequest) Send(ctx context.Context) (*RegisterTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterTypeResponse{
		RegisterTypeOutput: r.Request.Data.(*RegisterTypeOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterTypeResponse is the response type for the
// RegisterType API operation.
type RegisterTypeResponse struct {
	*RegisterTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterType request.
func (r *RegisterTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
