// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeregisterTypeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the type.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Arn *string `type:"string"`

	// The kind of type.
	//
	// Currently the only valid value is RESOURCE.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Type RegistryType `type:"string" enum:"true"`

	// The name of the type.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	TypeName *string `min:"10" type:"string"`

	// The ID of a specific version of the type. The version ID is the value at
	// the end of the Amazon Resource Name (ARN) assigned to the type version when
	// it is registered.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeregisterTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterTypeInput"}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 10))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterTypeOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterType = "DeregisterType"

// DeregisterTypeRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Removes a type or type version from active use in the CloudFormation registry.
// If a type or type version is deregistered, it cannot be used in CloudFormation
// operations.
//
// To deregister a type, you must individually deregister all registered versions
// of that type. If a type has only a single registered version, deregistering
// that version results in the type itself being deregistered.
//
// You cannot deregister the default version of a type, unless it is the only
// registered version of that type, in which case the type itself is deregistered
// as well.
//
//    // Example sending a request using DeregisterTypeRequest.
//    req := client.DeregisterTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType
func (c *Client) DeregisterTypeRequest(input *DeregisterTypeInput) DeregisterTypeRequest {
	op := &aws.Operation{
		Name:       opDeregisterType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTypeInput{}
	}

	req := c.newRequest(op, input, &DeregisterTypeOutput{})

	return DeregisterTypeRequest{Request: req, Input: input, Copy: c.DeregisterTypeRequest}
}

// DeregisterTypeRequest is the request type for the
// DeregisterType API operation.
type DeregisterTypeRequest struct {
	*aws.Request
	Input *DeregisterTypeInput
	Copy  func(*DeregisterTypeInput) DeregisterTypeRequest
}

// Send marshals and sends the DeregisterType API request.
func (r DeregisterTypeRequest) Send(ctx context.Context) (*DeregisterTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterTypeResponse{
		DeregisterTypeOutput: r.Request.Data.(*DeregisterTypeOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterTypeResponse is the response type for the
// DeregisterType API operation.
type DeregisterTypeResponse struct {
	*DeregisterTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterType request.
func (r *DeregisterTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
