// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// The input for the CancelUpdateStack action.
type CancelUpdateStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this CancelUpdateStack request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to cancel an update on a stack with the same name. You might
	// retry CancelUpdateStack requests to ensure that AWS CloudFormation successfully
	// received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelUpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelUpdateStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelUpdateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelUpdateStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelUpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelUpdateStack = "CancelUpdateStack"

// CancelUpdateStackRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Cancels an update on the specified stack. If the call completes successfully,
// the stack rolls back the update and reverts to the previous stack configuration.
//
// You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
//
//    // Example sending a request using CancelUpdateStackRequest.
//    req := client.CancelUpdateStackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *Client) CancelUpdateStackRequest(input *CancelUpdateStackInput) CancelUpdateStackRequest {
	op := &aws.Operation{
		Name:       opCancelUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelUpdateStackInput{}
	}

	req := c.newRequest(op, input, &CancelUpdateStackOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return CancelUpdateStackRequest{Request: req, Input: input, Copy: c.CancelUpdateStackRequest}
}

// CancelUpdateStackRequest is the request type for the
// CancelUpdateStack API operation.
type CancelUpdateStackRequest struct {
	*aws.Request
	Input *CancelUpdateStackInput
	Copy  func(*CancelUpdateStackInput) CancelUpdateStackRequest
}

// Send marshals and sends the CancelUpdateStack API request.
func (r CancelUpdateStackRequest) Send(ctx context.Context) (*CancelUpdateStackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelUpdateStackResponse{
		CancelUpdateStackOutput: r.Request.Data.(*CancelUpdateStackOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelUpdateStackResponse is the response type for the
// CancelUpdateStack API operation.
type CancelUpdateStackResponse struct {
	*CancelUpdateStackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelUpdateStack request.
func (r *CancelUpdateStackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
