// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListProxySessionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The proxy session status.
	Status ProxySessionStatus `location:"querystring" locationName:"status" type:"string" enum:"true"`

	// The Amazon Chime voice connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProxySessionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProxySessionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProxySessionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProxySessionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListProxySessionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The proxy session details.
	ProxySessions []ProxySession `type:"list"`
}

// String returns the string representation
func (s ListProxySessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProxySessionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProxySessions != nil {
		v := s.ProxySessions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProxySessions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListProxySessions = "ListProxySessions"

// ListProxySessionsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Lists the proxy sessions for the specified Amazon Chime Voice Connector.
//
//    // Example sending a request using ListProxySessionsRequest.
//    req := client.ListProxySessionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListProxySessions
func (c *Client) ListProxySessionsRequest(input *ListProxySessionsInput) ListProxySessionsRequest {
	op := &aws.Operation{
		Name:       opListProxySessions,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProxySessionsInput{}
	}

	req := c.newRequest(op, input, &ListProxySessionsOutput{})

	return ListProxySessionsRequest{Request: req, Input: input, Copy: c.ListProxySessionsRequest}
}

// ListProxySessionsRequest is the request type for the
// ListProxySessions API operation.
type ListProxySessionsRequest struct {
	*aws.Request
	Input *ListProxySessionsInput
	Copy  func(*ListProxySessionsInput) ListProxySessionsRequest
}

// Send marshals and sends the ListProxySessions API request.
func (r ListProxySessionsRequest) Send(ctx context.Context) (*ListProxySessionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProxySessionsResponse{
		ListProxySessionsOutput: r.Request.Data.(*ListProxySessionsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProxySessionsRequestPaginator returns a paginator for ListProxySessions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProxySessionsRequest(input)
//   p := chime.NewListProxySessionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProxySessionsPaginator(req ListProxySessionsRequest) ListProxySessionsPaginator {
	return ListProxySessionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProxySessionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProxySessionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProxySessionsPaginator struct {
	aws.Pager
}

func (p *ListProxySessionsPaginator) CurrentPage() *ListProxySessionsOutput {
	return p.Pager.CurrentPage().(*ListProxySessionsOutput)
}

// ListProxySessionsResponse is the response type for the
// ListProxySessions API operation.
type ListProxySessionsResponse struct {
	*ListProxySessionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProxySessions request.
func (r *ListProxySessionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
